library(stockassessment)
setwd("data")

cn<-read.ices("cn.dat")
W<-matrix(1, nrow=nrow(cn), ncol=ncol(cn)); W[nrow(cn),]<-0.5; attr(cn,"weight")<-W
cw<-read.ices("cw.dat")
dw<-read.ices("dw.dat")
lw<-read.ices("lw.dat")
mo<-read.ices("mo.dat")
nm<-read.ices("nm.dat")
pf<-read.ices("pf.dat")
pm<-read.ices("pm.dat")
sw<-read.ices("sw.dat")
lf<-read.ices("lf.dat")

surveys<-read.ices("survey.dat")
#W<-matrix(1, nrow=nrow(surveys[[1]]), ncol=ncol(surveys[[1]])); W[nrow(surveys[[1]])+c(0,-1,-2),]<-0.01; attr(surveys[[1]],"weight")<-W





setwd("..")

dat<-setup.sam.data(surveys=surveys,
                    residual.fleet=cn, 
                    prop.mature=mo, 
                    stock.mean.weight=sw, 
                    catch.mean.weight=cw, 
                    dis.mean.weight=dw, 
                    land.mean.weight=lw,
                    prop.f=pf, 
                    prop.m=pm, 
                    natural.mortality=nm, 
                    land.frac=lf)
dat<-reduce(dat,age=0)

save(dat, file="run/data.RData")
