% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim.R
\name{sim.spict}
\alias{sim.spict}
\title{Simulate data from Pella-Tomlinson model}
\usage{
sim.spict(input, nobs = 100)
}
\arguments{
\item{input}{Either an inp list with an ini key (see ?check.inp) or a rep list where rep is the output of running fit.spict().}

\item{nobs}{Optional specification of the number of simulated observations.}
}
\value{
A list containing the simulated data.
}
\description{
Simulate data from Pella-Tomlinson model
}
\details{
Simulates data using either manually specified parameters values or parameters estimated by fit.spict().

Manual specification:
To specify parameters manually use the inp$ini format similar to when specifying initial values for running fit.spict(). Observations can be simulated at specific times using inp$timeC and inp$timeI. If these are not specified then the length of inp$obsC or inp$obsI is used to determine the number of observations of catches and indices respectively. If none of these are specified then nobs observations of catch and index will be simulated evenly distributed in time.

Estimated parameters:
Simply take the output from a fit.spict() run and use as input to sim.spict().
}
\examples{
data(pol)
repin <- fit.spict(pol$albacore)
# Simulate a specific number of observations
inp <- list()
inp$dteuler <- 1/4 # To reduce calculation time
inp$ini <- repin$inp$ini
inp$ini$logF <- NULL
inp$ini$logB <- NULL
set.seed(1)
sim <- sim.spict(inp, nobs=150)
repsim <- fit.spict(sim)
summary(repsim) # Note true values are listed in the summary
plot(repsim) # Note true states are shown with orange colour

# Simulate data with seasonal F
inp <- list()
inp$dteuler <- 1/4
inp$nseasons <- 2
inp$splineorder <- 1
inp$obsC <- 1:80
inp$obsI <- 1:80
inp$ini <- repin$inp$ini
inp$ini$logF <- NULL
inp$ini$logB <- NULL
inp$ini$logphi <- log(2) # Seasonality introduced here
inp <- check.inp(inp)
sim2 <- sim.spict(inp)
par(mfrow=c(2, 1))
plot(sim2$obsC, typ='l')
plot(sim2$obsI[[1]], typ='l')
}

