% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.fb}
\alias{plotspict.fb}
\title{Plot fishing mortality versus biomass.}
\usage{
plotspict.fb(rep, logax = FALSE, plot.legend = TRUE, ext = TRUE,
  rel.axes = FALSE, xlim = NULL, ylim = NULL, labpos = c(1, 1),
  xlabel = NULL, stamp = get.version())
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of x and y-axes? default: FALSE}

\item{plot.legend}{Plot legend explaining triangle.}

\item{ext}{Add relative level axis to top and right side.}

\item{rel.axes}{Plot axes in relative levels instead of absolute.}

\item{xlim}{Limits of x-axis.}

\item{ylim}{Limits of y-axis.}

\item{labpos}{Positions of time stamps of start and end points as in pos in text().}

\item{xlabel}{Label of x-axis. If NULL not used.}

\item{stamp}{Stamp plot with this character string.}
}
\value{
Nothing.
}
\description{
Plot fishing mortality versus biomass.
}
\details{
Plots estimated fishing mortality as a function of biomass together with reference points and the prediction for next year given a constant F. The equilibrium biomass for F fixed to the current value is also plotted.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.fb(rep)
}

