% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manage.R
\name{manage}
\alias{manage}
\title{Calculate predictions under different management scenarios}
\usage{
manage(repin, scenarios = "all", manstart = NULL, dbg = 0)
}
\arguments{
\item{repin}{Result list from fit.spict().}

\item{scenarios}{Vector of integers specifying which scenarios to run. Default: 'all'.}

\item{dbg}{Debug flag, dbg=1 some output, dbg=2 more ourput.}
}
\value{
List containing results of management calculations.
}
\description{
Calculate predictions under different management scenarios
}
\details{
Scenarios that are currently implemented include:
\itemize{
  \item{"1"}{ Keep the catch of the current year (i.e. the last observed catch).}
  \item{"2"}{ Keep the F of the current year.}
  \item{"3"}{ Fish at Fmsy i.e. F=Fmsy.}
  \item{"4"}{ No fishing, reduce to 1\% of current F.}
  \item{"5"}{ Reduce F by X\%. Default X = 25.}
  \item{"6"}{ Increase F by X\%. Default X = 25.}
}
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
repman <- manage(rep)
}

