% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim.R
\name{validate.spict}
\alias{validate.spict}
\title{Simulate data and reestimate parameters}
\usage{
validate.spict(inp, nsim = 50, nobsvec = c(15, 60, 240), estinp = NULL,
  backup = NULL, df.out = FALSE, summ.ex.file = NULL)
}
\arguments{
\item{inp}{An inp list with an ini key (see ?check.inp). If you want to use estimated parameters for the simulation create the inp$ini from the pl key of a result of fit.spict().}

\item{nsim}{Number of simulated data sets in each batch.}

\item{nobsvec}{Vector containing the number of simulated observations of each data set in each batch.}

\item{estinp}{The estimation uses the true parameters as starting guess. Other initial values to be used for estimation can be specified in estinp$ini.}

\item{backup}{Since this procedure can be slow a filename can be specified in backup where the most recent results will be available.}

\item{df.out}{Output data frame instead of list.}

\item{summ.ex.file}{Save a summary example to this file (to check that parameters have correct priors or are fixed).}
}
\value{
A list containing the results of the validation with the following keys:
\itemize{
 \item{"osarpvals"}{ P-values of the Ljung-Box test for uncorrelated one-step-ahead residuals.}
 \item{"*msyci"}{Logical. TRUE if the true value of B/Fmsy was inside the 95\% confidence interval for the estimate, otherwise FALSE}
 \item{"*msyciw"}{ Width of the 95\% confidence interval of the estimate of Bmsy/Fmsy.}
}
}
\description{
Simulate data and reestimate parameters
}
\details{
Given input parameters simulate a number of data sets. Then estimate the parameters from the simulated data and compare with the true values. Specifically, the one-step-ahead residuals are checked for autocorrelation and the confidence intervals of the estimated Fmsy and Bmsy are checked for consistency.

WARNING: One should simulate at least 50 data sets and preferably more than 100 to obtain reliable results. This will take some time (potentially hours).
}
\examples{
data(pol)
rep0 <- fit.spict(pol$albacore)
inp <- list()
inp$ini <- rep0$pl
set.seed(1234)
validate.spict(inp, nsim=10, nobsvec=c(30, 60), backup='validate.RData')
}

