% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.production}
\alias{plotspict.production}
\title{Plot theoretical production curve and estimates.}
\usage{
plotspict.production(rep, n.plotyears = 40, main = "Production curve")
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{n.plotyears}{Plot years next to points if number of points is below n.plotyears. Default: 40.}

\item{main}{Title of plot.}
}
\value{
Nothing.
}
\description{
Plot theoretical production curve and estimates.
}
\details{
Plots the theoretical production curve (production as a function of biomass) as calculated from the estimated model parameters. Overlaid is the estimated production/biomass trajectory.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.production(rep)
}

