% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.f}
\alias{plotspict.f}
\title{Plot estimated fishing mortality.}
\usage{
plotspict.f(rep, logax = FALSE, main = "Absolute fishing mortality",
  ylim = NULL, xlab = "Time", ylab = NULL, rel.axes = TRUE,
  rel.ci = TRUE)
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of y-axis? default: FALSE}

\item{main}{Title of plot.}

\item{ylim}{Limits for y-axis.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{rel.axes}{Plot secondary y-axis contatning relative level of F.}

\item{rel.ci}{Plot confidence interval for relative level of F.}
}
\value{
Nothing.
}
\description{
Plot estimated fishing mortality.
}
\details{
Plots estimated fishing mortality with Fmsy and associated confidence interval.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.f(rep)
}

