% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utility.R
\name{get.par}
\alias{get.par}
\title{Extract parameters from a result report as generated by fit.spict.}
\usage{
get.par(parname, rep = rep, exp = FALSE, random = FALSE, fixed = FALSE)
}
\arguments{
\item{parname}{Character string containing the name of the variable of interest.}

\item{rep}{A result report as generated by running fit.spict.}

\item{exp}{Take exp of the variable? TRUE/FALSE.}

\item{random}{DUMMY not used anymore. (Is the variable a random effect? TRUE/FALSE.)}

\item{fixed}{DUMMY not used anymore. (Is the variable a fixed effect? TRUE/FALSE.)}
}
\value{
A matrix with four columns containing respectively: 1) the lower 95% confidence limit; 2) the parameter estimate; 3) the upper 95% confidence limit; 4) the parameter standard deviation in the domain it was estimated (log or non-log).
}
\description{
Extract parameters from a result report as generated by fit.spict.
}
\details{
Helper function for extracting the value and uncertainty of a specific model parameter, random effect or derived quantity.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
Bmsy <- get.par('logBmsy', rep, exp=TRUE)
Best <- get.par('logB', rep, exp=TRUE)
K <- get.par('logK', rep, exp=TRUE)
}

