% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.f}
\alias{plotspict.f}
\title{Plot estimated fishing mortality.}
\usage{
plotspict.f(rep, logax = FALSE, main = "Absolute fishing mortality",
  ylim = NULL, plot.obs = TRUE, qlegend = TRUE, xlab = "Time",
  ylab = NULL, rel.axes = TRUE, rel.ci = TRUE, stamp = get.version())
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of y-axis? default: FALSE}

\item{main}{Title of plot.}

\item{ylim}{Limits for y-axis.}

\item{plot.obs}{If TRUE observations are plotted.}

\item{qlegend}{If TRUE legend explaining colours of observation data is plotted.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{rel.axes}{Plot secondary y-axis contatning relative level of F.}

\item{rel.ci}{Plot confidence interval for relative level of F.}

\item{stamp}{Stamp plot with this character string.}
}
\value{
Nothing.
}
\details{
Plots estimated fishing mortality with Fmsy and associated confidence interval.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.f(rep)
}

