% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.catch}
\alias{plotspict.catch}
\title{Plot observed catch and predictions.}
\usage{
plotspict.catch(rep, main = "Catch", ylim = NULL, qlegend = TRUE,
  lcol = "blue", xlab = "Time", ylab = NULL, stamp = get.version())
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{main}{Title of plot.}

\item{ylim}{Limits for y-axis.}

\item{qlegend}{If TRUE legend explaining colours of observation data is plotted.}

\item{lcol}{Colour of prediction lines.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{stamp}{Stamp plot with this character string.}
}
\value{
Nothing.
}
\details{
Plots observed catch and predictions using the current F and Fmsy. The plot also contains the equilibrium catch if the current F is maintained.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.catch(rep)
}

