% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meyermillar.R
\name{fit.meyermillar}
\alias{fit.meyermillar}
\title{Fit the model of Meyer & Millar (1999)}
\usage{
fit.meyermillar(mminp)
}
\arguments{
\item{mminp}{Input list similar to the input to fit.spict()}
}
\value{
List containing results
}
\details{
Same input structure as for fit.spict(). Fitting the model of Meyer & Millar requires the packages rjags and coda. It furthermore requires that priors are specified for K, r, q, sigma2 (process error variance) and tau2 (observation error variance). Following Meyer & Millar (1999) the priors are:
\itemize{
 \item{"K"}{ log-normal.}
 \item{"r"}{ log-normal.}
 \item{"q"}{ inverse-gamma.}
 \item{"tau2"}{ inverse-gamma.}
 \item{"sigma2"}{ inverse-gamma.}
}
See example for how to specify priors.
}
\examples{
priors <- list()
priors$K <- c(5.042905, 3.76)
priors$r <- c(-1.38, 3.845)
priors$iq <- c(0.001, 0.0012)
priors$itau2 <- c(1.709, 0.00861342)
priors$isigma2 <- c(3.785518, 0.0102232)
priors$logPini <- -0.223
data(pol)
inp <- pol$albacore
inp$meyermillar$n.iter <- 10000
inp$meyermillar$burnin <- 1000
inp$meyermillar$thin <- 10
inp$meyermillar$n.chains <- 1
inp$meyermillar$priors <- priors
res <- fit.meyermillar(inp)
summary(res$jags)
}

