% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlmtool.R
\docType{data}
\name{SPiCT_Feq08Fmsy}
\alias{SPiCT_Feq08Fmsy}
\title{SPiCT assessment with F equal 80\% Fmsy harvest control rule}
\format{An object of class \code{DLM_output} of length 1.}
\usage{
SPiCT_Feq08Fmsy
}
\arguments{
\item{x}{A position in a data-limited mehods data object}

\item{DLM_data}{A data-limited methods data object (see DLMtool)}

\item{reps}{The number of stochastic samples of the TAC recommendation}
}
\value{
A numeric vector of TAC recommendations
}
\details{
SPiCT assessment is done using catch and relative biomass index observations. 
Stock status estimates are used to set the TAC for the next year, equal to the
catch that corresponds to fishing mortality equal to 80\% of Fmsy.
}
\examples{
\dontrun{
library(DLMtool)

## Put together an operating model from the available DLM toolkit examples
stock <- DLMdat[[6]] ## Herring
Fleet.example <- DLMdat[[22]] # Generic_IncE
Observation.example <- DLMdat[[34]] # Precise_Unbiased

## Remove changes in life history parameters
stock@Mgrad <- c(0,0)
stock@Kgrad <- c(0,0)
stock@Linfgrad <- c(0,0)
stock@Prob_staying <- c(1,1)

## Set the depletion level 
stock@D <- c(0.3, 0.4)

OM.example <- new("OM", Stock = stock, Fleet = Fleet.example, 
                  Observation = Observation.example)

MP.vec <- c("SPiCT_Feq08Fmsy")

MSE.example <- runMSE(OM.example, MPs = MP.vec, nsim = 200, proyears = 20,
                      interval = 1, reps = 100, timelimit = 150, CheckMPs = FALSE)
}
}
\keyword{datasets}

