/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.util.TimedHashMap;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;

public class PluginProxySelector
extends JNLPProxySelector {
    private TimedHashMap<String, Proxy> proxyCache = new TimedHashMap();

    public PluginProxySelector(DeploymentConfiguration config) {
        super(config);
    }

    protected List<Proxy> getFromBrowser(URI uri) {
        String requestURI;
        ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
        Proxy cachedProxy = this.checkCache(uri);
        if (cachedProxy != null) {
            proxyList.add(cachedProxy);
            return proxyList;
        }
        try {
            requestURI = PluginProxySelector.convertUriSchemeForProxyQuery(uri);
        }
        catch (Exception e) {
            PluginDebug.debug("Cannot construct URL from ", uri.toString(), " ... falling back to DIRECT proxy");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, (Throwable)e);
            proxyList.add(Proxy.NO_PROXY);
            return proxyList;
        }
        Proxy proxy = Proxy.NO_PROXY;
        Object o = this.getProxyFromRemoteCallToBrowser(requestURI);
        try {
            if (o != null) {
                PluginDebug.debug("Proxy URI = ", o);
                URI proxyURI = (URI)o;
                if (uri.getScheme().startsWith("http") || uri.getScheme().equals("ftp") || proxyURI.getScheme().startsWith("socks")) {
                    Proxy.Type type = proxyURI.getScheme().equals("http") ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
                    InetSocketAddress socketAddr = new InetSocketAddress(proxyURI.getHost(), proxyURI.getPort());
                    proxy = new Proxy(type, socketAddr);
                    String uriKey = this.computeKey(uri);
                    this.proxyCache.put((Object)uriKey, (Object)proxy);
                } else {
                    PluginDebug.debug("Proxy ", proxyURI, " cannot be used for ", uri, ". Falling back to DIRECT");
                }
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, (Throwable)e);
        }
        proxyList.add(proxy);
        PluginDebug.debug("Proxy for ", uri.toString(), " is ", proxy);
        return proxyList;
    }

    protected Object getProxyFromRemoteCallToBrowser(String uri) {
        return PluginAppletViewer.requestPluginProxyInfo(uri);
    }

    private Proxy checkCache(URI uri) {
        String uriKey = this.computeKey(uri);
        if (this.proxyCache.get((Object)uriKey) != null) {
            return (Proxy)this.proxyCache.get((Object)uriKey);
        }
        return null;
    }

    private String computeKey(URI uri) {
        return uri.getScheme() + "://" + uri.getHost();
    }

    public static String convertUriSchemeForProxyQuery(URI uri) throws URISyntaxException, UnsupportedEncodingException {
        String scheme = uri.getScheme();
        if (!scheme.startsWith("http") && !scheme.equals("ftp")) {
            scheme = "http";
        }
        URI result = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return UrlUtil.encode(result.toString(), "UTF-8");
    }
}

