/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.PropertyPermission;
import javax.sound.sampled.AudioPermission;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;

public class TemporaryPermissions {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String TMPDIR = System.getProperty("java.io.tmpdir");
    public static final FilePermission READ_LOCAL_FILES_PERMISSION = new FilePermission(USER_HOME, PolicyEditorPermissions.READ_LOCAL_FILES.getActions().rawString());
    public static final FilePermission WRITE_LOCAL_FILES_PERMISSION = new FilePermission(USER_HOME, PolicyEditorPermissions.WRITE_LOCAL_FILES.getActions().rawString());
    public static final FilePermission DELETE_LOCAL_FILES_PERMISSION = new FilePermission(USER_HOME, PolicyEditorPermissions.DELETE_LOCAL_FILES.getActions().rawString());
    public static final FilePermission READ_TMP_FILES_PERMISSION = new FilePermission(TMPDIR, PolicyEditorPermissions.READ_TMP_FILES.getActions().rawString());
    public static final FilePermission WRITE_TMP_FILES_PERMISSION = new FilePermission(TMPDIR, PolicyEditorPermissions.WRITE_TMP_FILES.getActions().rawString());
    public static final FilePermission DELETE_TMP_FILES_PERMISSION = new FilePermission(TMPDIR, PolicyEditorPermissions.DELETE_TMP_FILES.getActions().rawString());
    public static final FilePermission READ_SYSTEM_FILES_PERMISSION = new FilePermission(PolicyEditorPermissions.READ_SYSTEM_FILES.getTarget().target, PolicyEditorPermissions.READ_SYSTEM_FILES.getActions().rawString());
    public static final FilePermission WRITE_SYSTEM_FILES_PERMISSION = new FilePermission(PolicyEditorPermissions.WRITE_SYSTEM_FILES.getTarget().target, PolicyEditorPermissions.WRITE_SYSTEM_FILES.getActions().rawString());
    public static final PropertyPermission READ_PROPERTIES_PERMISSION = new PropertyPermission(PolicyEditorPermissions.READ_PROPERTIES.getTarget().target, PolicyEditorPermissions.READ_PROPERTIES.getActions().rawString());
    public static final PropertyPermission WRITE_PROPERTIES_PERMISSION = new PropertyPermission(PolicyEditorPermissions.WRITE_PROPERTIES.getTarget().target, PolicyEditorPermissions.WRITE_PROPERTIES.getActions().rawString());
    public static final FilePermission EXEC_PERMISSION = new FilePermission(PolicyEditorPermissions.EXEC_COMMANDS.getTarget().target, PolicyEditorPermissions.EXEC_COMMANDS.getActions().rawString());
    public static final RuntimePermission GETENV_PERMISSION = new RuntimePermission(PolicyEditorPermissions.GET_ENV.getTarget().target);
    public static final SocketPermission NETWORK_PERMISSION = new SocketPermission(PolicyEditorPermissions.NETWORK.getTarget().target, PolicyEditorPermissions.NETWORK.getActions().rawString());
    public static final ReflectPermission REFLECTION_PERMISSION = new ReflectPermission(PolicyEditorPermissions.JAVA_REFLECTION.getTarget().target);
    public static final RuntimePermission CLASSLOADER_PERMISSION = new RuntimePermission(PolicyEditorPermissions.GET_CLASSLOADER.getTarget().target);
    public static final RuntimePermission ACCESS_CLASS_IN_PACKAGE_PERMISSION = new RuntimePermission(PolicyEditorPermissions.ACCESS_CLASS_IN_PACKAGE.getTarget().target);
    public static final RuntimePermission ACCESS_DECLARED_MEMBERS_PERMISSION = new RuntimePermission(PolicyEditorPermissions.ACCESS_DECLARED_MEMBERS.getTarget().target);
    public static final RuntimePermission ACCESS_THREADS_PERMISSION = new RuntimePermission(PolicyEditorPermissions.ACCESS_THREADS.getTarget().target);
    public static final RuntimePermission ACCESS_THREADGROUPS_PERMISSION = new RuntimePermission(PolicyEditorPermissions.ACCESS_THREAD_GROUPS.getTarget().target);
    public static final AWTPermission AWT_PERMISSION = new AWTPermission(PolicyEditorPermissions.ALL_AWT.getTarget().target);
    public static final AudioPermission PLAY_AUDIO_PERMISSION = new AudioPermission(PolicyEditorPermissions.PLAY_AUDIO.getTarget().target);
    public static final AudioPermission RECORD_AUDIO_PERMISSION = new AudioPermission(PolicyEditorPermissions.RECORD_AUDIO.getTarget().target);
    public static final AWTPermission CLIPBOARD_PERMISSION = new AWTPermission(PolicyEditorPermissions.CLIPBOARD.getTarget().target);
    public static final RuntimePermission PRINT_PERMISSION = new RuntimePermission(PolicyEditorPermissions.PRINT.getTarget().target);
    public static final Collection<Permission> ALL_PERMISSIONS;
    public static final Collection<Permission> FILE_PERMISSIONS;
    public static final Collection<Permission> PROPERTY_PERMISSIONS;
    public static final Collection<Permission> NETWORK_PERMISSIONS;
    public static final Collection<Permission> EXEC_PERMISSIONS;
    public static final Collection<Permission> REFLECTION_PERMISSIONS;
    public static final Collection<Permission> MEDIA_PERMISSIONS;

    private static final Collection<Permission> allMinus(Collection<Permission> permissions) {
        return TemporaryPermissions.subtract(ALL_PERMISSIONS, permissions);
    }

    private static Collection<Permission> sum(Permission ... permissions) {
        HashSet<Permission> result = new HashSet<Permission>(Arrays.asList(permissions));
        return Collections.unmodifiableCollection(result);
    }

    private static Collection<Permission> sum(Collection<Permission> a, Collection<Permission> b) {
        HashSet<Permission> result = new HashSet<Permission>();
        result.addAll(a);
        result.addAll(b);
        return Collections.unmodifiableCollection(result);
    }

    private static final Collection<Permission> subtract(Collection<Permission> from, Collection<Permission> remove) {
        HashSet<Permission> result = new HashSet<Permission>(from);
        result.removeAll(remove);
        return Collections.unmodifiableCollection(result);
    }

    public static Collection<Permission> noFileAccess() {
        return TemporaryPermissions.allMinus(FILE_PERMISSIONS);
    }

    public static Collection<Permission> noNetworkAccess() {
        return TemporaryPermissions.allMinus(Arrays.asList(NETWORK_PERMISSION));
    }

    public static Collection<Permission> noFileOrNetworkAccess() {
        return TemporaryPermissions.subtract(TemporaryPermissions.allMinus(FILE_PERMISSIONS), NETWORK_PERMISSIONS);
    }

    public static Collection<Permission> allFileAccessAndProperties() {
        return TemporaryPermissions.sum(FILE_PERMISSIONS, PROPERTY_PERMISSIONS);
    }

    public static Collection<Permission> readLocalFilesAndProperties() {
        return TemporaryPermissions.sum(READ_LOCAL_FILES_PERMISSION, READ_PROPERTIES_PERMISSION);
    }

    public static Collection<Permission> reflectionOnly() {
        return REFLECTION_PERMISSIONS;
    }

    public static Collection<Permission> allMedia() {
        return MEDIA_PERMISSIONS;
    }

    public static Collection<Permission> audioOnly() {
        return TemporaryPermissions.sum(PLAY_AUDIO_PERMISSION, RECORD_AUDIO_PERMISSION);
    }

    public static Collection<Permission> clipboardOnly() {
        return TemporaryPermissions.sum(CLIPBOARD_PERMISSION);
    }

    public static Collection<Permission> printOnly() {
        return TemporaryPermissions.sum(PRINT_PERMISSION);
    }

    static {
        HashSet all = new HashSet();
        HashSet<FilePermission> file = new HashSet<FilePermission>();
        HashSet<PropertyPermission> property = new HashSet<PropertyPermission>();
        HashSet<SocketPermission> network = new HashSet<SocketPermission>();
        HashSet<Permission> exec = new HashSet<Permission>();
        HashSet<BasicPermission> reflection = new HashSet<BasicPermission>();
        HashSet<BasicPermission> media = new HashSet<BasicPermission>();
        file.add(READ_LOCAL_FILES_PERMISSION);
        file.add(WRITE_LOCAL_FILES_PERMISSION);
        file.add(DELETE_LOCAL_FILES_PERMISSION);
        file.add(READ_TMP_FILES_PERMISSION);
        file.add(WRITE_TMP_FILES_PERMISSION);
        file.add(DELETE_TMP_FILES_PERMISSION);
        file.add(READ_SYSTEM_FILES_PERMISSION);
        file.add(WRITE_SYSTEM_FILES_PERMISSION);
        FILE_PERMISSIONS = Collections.unmodifiableCollection(file);
        property.add(READ_PROPERTIES_PERMISSION);
        property.add(WRITE_PROPERTIES_PERMISSION);
        PROPERTY_PERMISSIONS = Collections.unmodifiableCollection(property);
        exec.add(EXEC_PERMISSION);
        exec.add(GETENV_PERMISSION);
        EXEC_PERMISSIONS = Collections.unmodifiableCollection(exec);
        network.add(NETWORK_PERMISSION);
        NETWORK_PERMISSIONS = Collections.unmodifiableCollection(network);
        reflection.add(REFLECTION_PERMISSION);
        reflection.add(CLASSLOADER_PERMISSION);
        reflection.add(ACCESS_CLASS_IN_PACKAGE_PERMISSION);
        reflection.add(ACCESS_DECLARED_MEMBERS_PERMISSION);
        reflection.add(ACCESS_THREADS_PERMISSION);
        reflection.add(ACCESS_THREADGROUPS_PERMISSION);
        REFLECTION_PERMISSIONS = Collections.unmodifiableCollection(reflection);
        media.add(AWT_PERMISSION);
        media.add(PLAY_AUDIO_PERMISSION);
        media.add(RECORD_AUDIO_PERMISSION);
        media.add(CLIPBOARD_PERMISSION);
        media.add(PRINT_PERMISSION);
        MEDIA_PERMISSIONS = Collections.unmodifiableCollection(media);
        all.addAll(file);
        all.addAll(property);
        all.addAll(exec);
        all.addAll(network);
        all.addAll(reflection);
        all.addAll(media);
        ALL_PERMISSIONS = Collections.unmodifiableCollection(all);
    }
}

