/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class UpdateCertificates {
    private char[] password = null;
    private String ksFilename = null;
    private KeyStore ks = null;
    private CertificateFactory certFactory = null;

    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        String string = "changeit";
        if (stringArray.length == 2 && stringArray[0].equals("-storepass")) {
            string = stringArray[1];
        } else if (stringArray.length > 0) {
            System.err.println("Usage: java UpdateCertificates [-storepass <password>]");
            System.exit(1);
        }
        try {
            UpdateCertificates updateCertificates = new UpdateCertificates(string, "/etc/ssl/certs/java/cacerts");
            updateCertificates.processChanges(new InputStreamReader(System.in, "UTF8"));
            updateCertificates.writeKeyStore();
        }
        catch (Exceptions.InvalidKeystorePassword invalidKeystorePassword) {
            invalidKeystorePassword.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exceptions.UnableToSaveKeystore unableToSaveKeystore) {
            unableToSaveKeystore.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public UpdateCertificates(String string, String string2) throws IOException, GeneralSecurityException, Exceptions.InvalidKeystorePassword {
        this.password = string.toCharArray();
        this.ksFilename = string2;
        this.ks = this.openKeyStore();
        this.certFactory = CertificateFactory.getInstance("X.509");
    }

    private KeyStore openKeyStore() throws GeneralSecurityException, IOException, Exceptions.InvalidKeystorePassword {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File file = new File(this.ksFilename);
        FileInputStream fileInputStream = null;
        if (file.canRead()) {
            fileInputStream = new FileInputStream(file);
        }
        try {
            keyStore.load(fileInputStream, this.password);
        }
        catch (IOException iOException) {
            throw new Exceptions.InvalidKeystorePassword("Cannot open Java keystore. Is the password correct?", iOException);
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        return keyStore;
    }

    protected void processChanges(Reader reader) throws IOException, GeneralSecurityException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            try {
                this.parseLine(string);
            }
            catch (Exceptions.UnknownInput unknownInput) {
                System.err.println("Unknown input: " + string);
            }
        }
    }

    protected void parseLine(String string) throws GeneralSecurityException, IOException, Exceptions.UnknownInput {
        assert (this.ks != null);
        String string2 = string.substring(1);
        String string3 = string2.substring(string2.lastIndexOf("/") + 1);
        String string4 = "debian:" + string3;
        if (string.startsWith("+")) {
            Certificate certificate = this.loadCertificate(string2);
            if (certificate == null) {
                return;
            }
            this.addAlias(string4, certificate);
        } else if (string.startsWith("-")) {
            this.deleteAlias(string4);
            this.deleteAlias(string3);
        } else {
            throw new Exceptions.UnknownInput(string);
        }
    }

    private void deleteAlias(String string) throws GeneralSecurityException {
        assert (this.ks != null);
        if (this.contains(string)) {
            System.out.println("Removing " + string);
            this.ks.deleteEntry(string);
        }
    }

    private void addAlias(String string, Certificate certificate) throws KeyStoreException {
        assert (this.ks != null);
        if (this.contains(string)) {
            System.out.println("Replacing " + string);
            this.ks.deleteEntry(string);
        } else {
            System.out.println("Adding " + string);
        }
        this.ks.setCertificateEntry(string, certificate);
    }

    protected boolean contains(String string) throws KeyStoreException {
        assert (this.ks != null);
        return this.ks.containsAlias(string);
    }

    private Certificate loadCertificate(String string) {
        assert (this.certFactory != null);
        Certificate certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            certificate = this.certFactory.generateCertificate(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Warning: there was a problem reading the certificate file " + string + ". Message:\n  " + exception.getMessage());
        }
        return certificate;
    }

    protected void writeKeyStore() throws GeneralSecurityException, Exceptions.UnableToSaveKeystore {
        assert (this.ks != null);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.ksFilename);
            this.ks.store(fileOutputStream, this.password);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new Exceptions.UnableToSaveKeystore("There was a problem saving the new Java keystore.", iOException);
        }
    }
}

