library(stockassessment)

oldwd<-setwd("data")

  cn<-read.ices("cn.dat")
  cw<-read.ices("cw.dat")
  dw<-read.ices("dw.dat")
  lw<-read.ices("lw.dat")
  mo<-read.ices("mo.dat")
  nm<-read.ices("nm.dat")
  pf<-read.ices("pf.dat")
  pm<-read.ices("pm.dat")
  sw<-read.ices("sw.dat")
  lf<-read.ices("lf.dat")
  surveys<-read.ices("survey.dat")

##  Read CVs for the LPUE survey (one value per year) 
mod.cvs <- stockassessment::read.ices(("LPUE_CV.dat"))
# Attach as the known observation precision for this 'fleet'
attr(surveys[[4]], "weight") <-1/log((mod.cvs[[1]])^2+1)

setwd(oldwd)

dat<-setup.sam.data(surveys=surveys,
                    residual.fleet=cn, 
                    prop.mature=mo, 
                    stock.mean.weight=sw, 
                    catch.mean.weight=cw, 
                    dis.mean.weight=dw, 
                    land.mean.weight=lw,
                    prop.f=pf, 
                    prop.m=pm, 
                    natural.mortality=nm, 
                    land.frac=lf)


save(dat, file="run/data.RData")
