% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.catch}
\alias{plotspict.catch}
\title{Plot observed catch and predictions.}
\usage{
plotspict.catch(rep, main = -1, plot.legend = TRUE, ylim = NULL,
  qlegend = TRUE, lcol = "blue")
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{main}{Title of plot.}

\item{plot.legend}{If TRUE legend is plotted.}

\item{ylim}{Limits for y-axis.}

\item{qlegend}{If TRUE legend explaining colours of observation data is plotted.}

\item{lcol}{Colour of prediction lines.}
}
\value{
Nothing.
}
\description{
Plot observed catch and predictions.
}
\details{
Plots observed catch and predictions using the current F and Fmsy. The plot also contains the equilibrium catch if the current F is maintained.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.catch(rep)
}

