% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.spictcls}
\alias{plot.spictcls}
\title{Plot summarising spict results.}
\usage{
\method{plot}{spictcls}(rep, logax = FALSE)
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of relevant axes? default: FALSE}
}
\value{
Nothing.
}
\description{
Plot summarising spict results.
}
\details{
Create a plot containing the following:
\itemize{
 \item{1. Estimated biomass using plotspict.biomass().}
 \item{2. Estimated fishing mortality using plotspict.f().}
 \item{3. Observed versus predicted catches using plotspict.catch().}
 \item{4. Estimated biomass relative to Bmsy using plotspict.bbmsy().}
 \item{5. Estimated fishing mortality relative to Fmsy using plotspict.ffmsy().}
 \item{6. Estimated F versus estimated B using plotspict.fb().}
 \item{7. Observed versus theoretical production using plotspict.production().}
}

Optional plots included if relevant:
\itemize{
 \item{ Estimated seasonal spline using plotspict.season().}
 \item{ Calculated time-constant using plotspict.tc().}
 \item{ First prior and corresponding posterior distribution using plotspict.priors().}
 \item{ One-step-ahead residuals of catches using plotspict.osar().}
 \item{ One-step-ahead residuals of catches using plotspict.osar().}
}
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plot(rep)
}

