% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.biomass}
\alias{plotspict.biomass}
\title{Plot estimated biomass.}
\usage{
plotspict.biomass(rep, logax = FALSE, main = "Absolute biomass",
  ylim = NULL, plot.obs = TRUE, qlegend = TRUE, xlab = "Time",
  ylab = NULL, rel.axes = TRUE, rel.ci = TRUE)
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of y-axis? default: FALSE}

\item{main}{Title of plot.}

\item{ylim}{Limits for y-axis.}

\item{plot.obs}{If TRUE observations are plotted.}

\item{qlegend}{If TRUE legend explaining colours of observation data is plotted.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{rel.axes}{Plot secondary y-axis contatning relative level of F.}

\item{rel.ci}{Plot confidence interval for relative level of F.}
}
\value{
Nothing.
}
\description{
Plot estimated biomass.
}
\details{
Plots estimated biomass, Bmsy with confidence limits.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.biomass(rep)
}

