% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/osar.R
\name{calc.osa.resid}
\alias{calc.osa.resid}
\title{Calculate one-step-ahead residuals.}
\usage{
calc.osa.resid(rep)
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}
}
\value{
An updated result report, which contains one-step-ahead residuals stored in $osarC and $osarI.
}
\description{
Calculate one-step-ahead residuals.
}
\details{
In TMB one-step-ahead residuals are calculated by sequentially including one data point at a time while keeping the model parameters fixed at their ML estimates. The calculated residuals are tested for independence, bias, and normality.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
rep <- calc.osa.resid(rep)
plotspict.osar(rep)
}

