% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspic.R
\name{read.aspic}
\alias{read.aspic}
\title{Reads ASPIC input file.}
\usage{
read.aspic(filename)
}
\arguments{
\item{filename}{Path of the ASPIC input file.}
}
\value{
A list of input variables that can be used as input to fit.spict().
}
\details{
Reads an input file following the ASPIC 7 format described in the ASPIC manual (found here http://www.mhprager.com/aspic.html).
}
\examples{
\dontrun{
filename <- 'YFT-SSE.a7inp' # or some other ASPIC 7 input file
inp <- read.aspic(filename)
rep <- fit.spict(inp)
summary(rep)
plot(rep)
}
}

