% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotspict.ffmsy}
\alias{plotspict.ffmsy}
\title{Plot estimated relative fishing mortality.}
\usage{
plotspict.ffmsy(rep, logax = FALSE, main = "Relative fishing mortality",
  ylim = NULL, plot.obs = TRUE, qlegend = TRUE, lineat = 1,
  xlab = "Time", stamp = get.version())
}
\arguments{
\item{rep}{A result report as generated by running fit.spict.}

\item{logax}{Take log of y-axis? default: FALSE}

\item{main}{Title of plot.}

\item{ylim}{Limits for y-axis.}

\item{plot.obs}{If TRUE observations are plotted.}

\item{qlegend}{If TRUE legend explaining colours of observation data is plotted.}

\item{lineat}{Draw horizontal line at this y-value.}

\item{xlab}{Label of x-axis.}

\item{stamp}{Stamp plot with this character string.}
}
\value{
Nothing.
}
\details{
Plots estimated fishing mortality with Fmsy and associated confidence interval.
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
plotspict.ffmsy(rep)
}

