% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get.par}
\alias{get.par}
\alias{list.quantities}
\title{Extract parameters from a result report as generated by fit.spict.}
\usage{
get.par(parname, rep = rep, exp = FALSE, random = FALSE, fixed = FALSE)

list.quantities(rep)
}
\arguments{
\item{parname}{Character string containing the name of the variable of interest.}

\item{rep}{A result report as generated by running \code{fit.spict}.}

\item{exp}{Take exp of the variable? TRUE/FALSE.}

\item{random}{DUMMY not used anymore. (Is the variable a random effect? TRUE/FALSE.)}

\item{fixed}{DUMMY not used anymore. (Is the variable a fixed effect? TRUE/FALSE.)}
}
\value{
get.par returns a matrix with four columns containing respectively: 1) the lower 95% confidence limit; 2) the parameter estimate; 3) the upper 95% confidence limit; 4) the parameter standard deviation in the domain it was estimated (log or non-log). `list.quantities` returns a vector with the names of all estimated parameters and derived quantities.
}
\details{
\code{get.par} is a helper function for extracting the value and uncertainty of a specific model parameter, random effect or derived quantity. \code{list.quantities} gives the names of all quantities.
}
\examples{
## Make the south Atlantic albacore assessment
data(pol)
rep <- fit.spict(pol$albacore)

## See all quantitites that can be extracted
list.quantities(rep)

## Extract the Bmsy reference point
Bmsy <- get.par('logBmsy', rep, exp=TRUE)

## Extract the exploitable biomass estimates
Best <- get.par('logB', rep, exp=TRUE)

## Extract the estimated caryting capacity
K <- get.par('logK', rep, exp=TRUE)
}

