% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spict.R
\name{fit.spict}
\alias{fit.spict}
\title{Fit a continuous-time surplus production model to data.}
\usage{
fit.spict(inp, dbg = 0)
}
\arguments{
\item{inp}{List of input variables as output by check.inp.}

\item{dbg}{Debugging option. Will print out runtime information useful for debugging if set to 1. Will print even more if set to 2.}
}
\value{
A result report containing estimates of model parameters, random effects (biomass and fishing mortality), reference points (Fmsy, Bmsy, MSY) including uncertainties given as standard deviations.
}
\details{
Fits the model using the TMB package and returns a result report containing estimates of model parameters, random effects (biomass and fishing mortality), reference points (Fmsy, Bmsy, MSY) including uncertainties given as standard deviations.

Model parameters using the formulation of Fletcher (1978):
\itemize{
  \item{"logn"}{ Parameter determining the shape of the production curve as in the generalised form of Pella & Tomlinson (1969).}
  \item{"logm"}{ Log of maximum sustainable yield.}
  \item{"logK"}{ Log of carrying capacity.}
  \item{"logq"}{ Log of catchability vector.}
  \item{"logsdb"}{ Log of standard deviation of biomass process error.}
  \item{"logsdf"}{ Log of standard deviation of fishing mortality process error.}
  \item{"logsdi"}{ Log of standard deviation of index observation error.}
  \item{"logsdc"}{ Log of standard deviation of catch observation error.}
}

Unobserved states estimated as random effects:
\itemize{
  \item{"logB"}{ Log of the biomass process given by the stochastic differential equation: dB_t = r*B_t*(1-(B_t/K)^n)*dt + sdb*dW_t, where dW_t is Brownian motion.}
  \item{"logF"}{ Log of the fishing mortality process given by: dlog(F_t) = f(t, sdf), where the function f depends on the choice of seasonal model.}
}

Other parameters (which are only needed in certain cases):
\itemize{
  \item{"logphi"}{ Log of parameters used to specify the cyclic B spline representing seasonal variation. Used when inp$nseasons > 1 and inp$seasontype = 1.}
  \item{"logU"}{ Log of the state of the coupled SDE system used to represent seasonal variation, i.e. when inp$nseasons > 1 and inp$seasontype = 2.}
  \item{"loglambda"}{ Log of damping parameter when using the coupled SDE system to represent seasonal variation, i.e. when inp$nseasons > 1 and inp$seasontype = 2.}
  \item{"logsdu"}{ Log of standard deviation of process error of U_t (the state of the coupled SDE system) used to represent seasonal variation, i.e. when inp$nseasons > 1 and inp$seasontype = 2.}
  \item{"logsde"}{ Log of standard deviation of observation error of effort data. Only used if effort data is part of input.}
  \item{"logp1robfac"}{ Log plus one of the coefficient to the standard deviation of the observation error when using a mixture distribution robust toward outliers, i.e. when either inp$robflag = 1 and/or inp$robflagi = 1.}
  \item{"logitpp"}{Logit of the proportion of narrow distribution when using a mixture distribution robust toward outliers, i.e. when either inp$robflag = 1 and/or inp$robflagi = 1.}
}

Parameters that can be derived from model parameters:
\itemize{
  \item{"logr"}{ Log of intrinsic growth rate (r = 4m/K).}
  \item{"logalpha"}{ Proportionality factor for the observation noise of the indices and the biomass process noise: sdi = exp(logalpha)*sdb. (normally set to logalpha=0)}
  \item{"logbeta"}{ Proportionality factor for the observation noise of the catches and the fishing mortality process noise: sdc = exp(logbeta)*sdf. (this is often difficult to estimate and can result in divergence of the optimisation. Normally set to logbeta=0)}
  \item{"logBmsy"}{ Log of the equilibrium biomass (Bmsy) when fished at Fmsy.}
  \item{"logFmsy"}{ Log of the fishing mortality (Fmsy) leading to the maximum sustainable yield.}
  \item{"MSY"}{ The yield when the biomass is at Bmsy and the fishing mortality is at Fmsy, i.e. the maximum sustainable yield.}
}

The above parameter values can be extracted from the fit.spict() results using get.par().

Model assumptions
\itemize{
  \item{"1"}{The intrinsic growth rate (r) represents a combination of natural mortality, growth, and recruitment.}
  \item{"2"}{The biomass B_t refers to the exploitable part of the stock. Estimates in absolute numbers (K, Bmsy, etc.) should be interpreted in light of this.}
  \item{"3"}{The stock is closed to migration.}
  \item{"4"}{Age and size-distribution are stable in time.}
  \item{"5"}{Constant catchability of the gear used to gather information for the biomass index.}
}
}
\examples{
data(pol)
rep <- fit.spict(pol$albacore)
Bmsy <- get.par('logBmsy', rep, exp=TRUE)
summary(rep)
plot(rep)
}

