% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspic.R
\name{fit.aspic}
\alias{fit.aspic}
\title{Fits aspic to the data contained in the input file}
\usage{
fit.aspic(input, do.boot = FALSE, nboot = NULL, ciperc = NULL,
  verbose = FALSE, filebase = "tmp", savefile = NULL)
}
\arguments{
\item{input}{A spict input list containing observations.}

\item{do.boot}{Do bootstrap to get uncertainties of estimates?}

\item{nboot}{Number of bootstrap runs (only used if do.boot=TRUE). Prager suggests in the ASPIC manual p. 13 to use nboot > 1000 if ciperc > 80.}

\item{ciperc}{Coverage percentage (integer between 0 and 100) of bootstrapped confidence intervals.}

\item{verbose}{If TRUE write information to screen.}

\item{filebase}{Basename of all generated aspic files.}

\item{savefile}{Save results to this file.}
}
\value{
List containing aspic results.
}
\details{
Only works on Linux. This furthermore requires that wine is installed and that aspic7 is installed and available to the PATH.
}

