/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.CustomPolicyViewer;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEntry;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.MD5SumWatcher;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PolicyEditor
extends JPanel {
    public static final String HELP_FLAG = "-help";
    public static final String FILE_FLAG = "-file";
    public static final String CODEBASE_FLAG = "-codebase";
    private static final String HELP_MESSAGE = "Usage:\t" + Translator.R("PEUsage") + "\n\n" + "  " + "-help" + "\t\t\t" + Translator.R("PEHelpFlag") + "\n" + "  " + "-file" + "\t\t\t" + Translator.R("PEFileFlag") + "\n" + "  " + "-codebase" + "\t\t" + Translator.R("PECodebaseFlag") + "\n";
    private static final String AUTOGENERATED_NOTICE = "/* DO NOT MODIFY! AUTO-GENERATED */";
    private File file;
    private boolean changesMade = false;
    private boolean closed = false;
    private final Map<String, Map<PolicyEditorPermissions, Boolean>> codebasePermissionsMap = new HashMap<String, Map<PolicyEditorPermissions, Boolean>>();
    private final Map<String, Set<CustomPermission>> customPermissionsMap = new HashMap<String, Set<CustomPermission>>();
    private final Map<PolicyEditorPermissions, JCheckBox> checkboxMap = new TreeMap<PolicyEditorPermissions, JCheckBox>();
    private final List<JCheckBoxWithGroup> groupBoxList = new ArrayList<JCheckBoxWithGroup>(PolicyEditorPermissions.Group.values().length);
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList list = new JList(this.listModel);
    private final JButton okButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JButton addCodebaseButton = new JButton();
    private final JButton removeCodebaseButton = new JButton();
    private final JFileChooser fileChooser;
    private CustomPolicyViewer cpViewer = null;
    private final WeakReference<PolicyEditor> weakThis = new WeakReference<PolicyEditor>(this);
    private MD5SumWatcher fileWatcher;
    private final ActionListener okButtonAction;
    private final ActionListener addCodebaseButtonAction;
    private final ActionListener removeCodebaseButtonAction;
    private final ActionListener openButtonAction;
    private final ActionListener saveAsButtonAction;
    private final ActionListener viewCustomButtonAction;
    private ActionListener closeButtonAction;

    public PolicyEditor(String filepath) {
        this.setLayout(new GridBagLayout());
        for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            JCheckBox box = new JCheckBox();
            box.setText(perm.getName());
            box.setToolTipText(perm.getDescription());
            this.checkboxMap.put(perm, box);
        }
        if (filepath != null) {
            this.file = new File(filepath);
            this.openAndParsePolicyFile();
        } else {
            this.resetCodebases();
        }
        this.fileChooser = new JFileChooser(this.file);
        this.fileChooser.setFileHidingEnabled(false);
        this.okButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int choice;
                if (PolicyEditor.this.file == null && (choice = PolicyEditor.this.fileChooser.showOpenDialog((Component)PolicyEditor.this.weakThis.get())) == 0) {
                    PolicyEditor.this.file = PolicyEditor.this.fileChooser.getSelectedFile();
                }
                if (PolicyEditor.this.file != null) {
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.okButton.setText(Translator.R("ButApply"));
        this.okButton.addActionListener(this.okButtonAction);
        this.addCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.interactivelyAddCodebase();
            }
        };
        this.addCodebaseButton.setText(Translator.R("PEAddCodebase"));
        this.addCodebaseButton.addActionListener(this.addCodebaseButtonAction);
        this.removeCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.removeCodebase((String)PolicyEditor.this.list.getSelectedValue());
            }
        };
        this.removeCodebaseButton.setText(Translator.R("PERemoveCodebase"));
        this.removeCodebaseButton.addActionListener(this.removeCodebaseButtonAction);
        this.openButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice;
                if (PolicyEditor.this.changesMade) {
                    int save = JOptionPane.showConfirmDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PESaveChanges"));
                    if (save == 0) {
                        if (PolicyEditor.this.file == null) {
                            int choice2 = PolicyEditor.this.fileChooser.showSaveDialog((Component)PolicyEditor.this.weakThis.get());
                            if (choice2 == 0) {
                                PolicyEditor.this.file = PolicyEditor.this.fileChooser.getSelectedFile();
                            } else if (choice2 == 1) {
                                return;
                            }
                        }
                        PolicyEditor.this.savePolicyFile();
                    } else if (save == 2) {
                        return;
                    }
                }
                if ((choice = PolicyEditor.this.fileChooser.showOpenDialog((Component)PolicyEditor.this.weakThis.get())) == 0) {
                    PolicyEditor.this.file = PolicyEditor.this.fileChooser.getSelectedFile();
                    PolicyEditor.this.openAndParsePolicyFile();
                }
            }
        };
        this.saveAsButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = PolicyEditor.this.fileChooser.showSaveDialog((Component)PolicyEditor.this.weakThis.get());
                if (choice == 0) {
                    PolicyEditor.this.file = PolicyEditor.this.fileChooser.getSelectedFile();
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.viewCustomButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String codebase = PolicyEditor.this.getSelectedCodebase();
                        if (codebase == null) {
                            return;
                        }
                        if (PolicyEditor.this.cpViewer == null) {
                            PolicyEditor.this.cpViewer = new CustomPolicyViewer((PolicyEditor)PolicyEditor.this.weakThis.get(), codebase, (Collection)PolicyEditor.this.customPermissionsMap.get(codebase));
                            PolicyEditor.this.cpViewer.setVisible(true);
                        } else {
                            PolicyEditor.this.cpViewer.toFront();
                            PolicyEditor.this.cpViewer.repaint();
                        }
                    }
                });
            }
        };
        this.setAccelerators();
        this.setupLayout();
    }

    private String getSelectedCodebase() {
        String codebase = (String)this.list.getSelectedValue();
        if (codebase == null || codebase.isEmpty()) {
            return null;
        }
        if (codebase.equals(Translator.R("PEGlobalSettings"))) {
            return "";
        }
        return codebase;
    }

    private static void preparePolicyEditorWindow(PolicyEditorWindow w, PolicyEditor e) {
        w.setModalityType(Dialog.ModalityType.MODELESS);
        w.setPolicyEditor(e);
        w.setTitle(Translator.R("PETitle"));
        w.setDefaultCloseOperation(2);
        w.setJMenuBar(PolicyEditor.createMenuBar(w.asWindow(), w.getPolicyEditor()));
        PolicyEditor.setupPolicyEditorWindow(w.asWindow(), w.getPolicyEditor());
    }

    private static void setupPolicyEditorWindow(final Window window, final PolicyEditor editor) {
        window.add(editor);
        window.pack();
        editor.setVisible(true);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((PolicyEditorWindow)((Object)window)).quit();
                window.dispose();
            }
        });
        editor.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((PolicyEditorWindow)((Object)window)).quit();
            }
        };
        editor.closeButton.setText(Translator.R("ButClose"));
        editor.closeButton.addActionListener(editor.closeButtonAction);
        AbstractAction saveAct = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.savePolicyFile();
            }
        };
        editor.setAccelerator(Translator.R("PEOkButtonMnemonic"), 8, (Action)saveAct, "OkButtonAccelerator");
        AbstractAction quitAct = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PolicyEditorWindow)((Object)window)).quit();
            }
        };
        editor.setAccelerator(Translator.R("PECancelButtonMnemonic"), 8, (Action)quitAct, "CancelButtonAccelerator");
        AbstractAction escAct = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PolicyEditorWindow)((Object)window)).quit();
            }
        };
        editor.setAccelerator(27, 8, (Action)escAct, "ExitOnEscape");
    }

    public static PolicyEditorWindow getPolicyEditorFrame(String filepath) {
        return new PolicyEditorFrame(new PolicyEditor(filepath));
    }

    public static PolicyEditorWindow getPolicyEditorDialog(String filepath) {
        return new PolicyEditorDialog(new PolicyEditor(filepath));
    }

    private void setClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    void customPolicyViewerClosing() {
        this.cpViewer = null;
    }

    private void setAccelerators() {
        this.setAddCodebaseAccelerator();
        this.setRemoveCodebaseAccelerator();
    }

    private void setAccelerator(String trigger, int modifiers, Action action, String identifier) {
        int trig;
        try {
            trig = Integer.parseInt(trigger);
        }
        catch (NumberFormatException nfe) {
            OutputController.getLogger().log("Unable to set accelerator action \"" + identifier + "\" for trigger \"" + trigger + "\"");
            OutputController.getLogger().log(nfe);
            return;
        }
        this.setAccelerator(trig, modifiers, action, identifier);
    }

    private void setAccelerator(int trigger, int modifiers, Action action, String identifier) {
        KeyStroke key = KeyStroke.getKeyStroke(trigger, modifiers);
        this.getInputMap(2).put(key, identifier);
        this.getActionMap().put(identifier, action);
    }

    private void setAddCodebaseAccelerator() {
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.interactivelyAddCodebase();
            }
        };
        this.setAccelerator(Translator.R("PEAddCodebaseMnemonic"), 8, (Action)act, "AddCodebaseAccelerator");
    }

    private void setRemoveCodebaseAccelerator() {
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.removeCodebase((String)PolicyEditor.this.list.getSelectedValue());
            }
        };
        this.setAccelerator(Translator.R("PERemoveCodebaseMnemonic"), 8, (Action)act, "RemoveCodebaseAccelerator");
    }

    public void addNewCodebase(final String codebase) {
        try {
            new URL(codebase);
        }
        catch (MalformedURLException mfue) {
            OutputController.getLogger().log("Could not add codebase " + codebase);
            OutputController.getLogger().log(mfue);
            return;
        }
        boolean existingCodebase = this.initializeMapForCodebase(codebase);
        final String model = codebase.isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
        if (!existingCodebase) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PolicyEditor.this.listModel.addElement(model);
                }
            });
            this.changesMade = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.list.setSelectedValue(model, true);
                PolicyEditor.this.updateCheckboxes(codebase);
            }
        });
    }

    public void addNewCodebases(Collection<String> codebases) {
        for (String codebase : codebases) {
            this.addNewCodebase(codebase);
        }
    }

    public void addNewCodebases(String[] codebases) {
        this.addNewCodebases(Arrays.asList(codebases));
    }

    public void interactivelyAddCodebase() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String codebase = "";
                boolean stopAsking = false;
                while (!stopAsking) {
                    codebase = JOptionPane.showInputDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PECodebasePrompt"), "http://");
                    if (codebase == null) {
                        return;
                    }
                    try {
                        URL u = new URL(codebase);
                        if (u.getProtocol() == null || u.getHost() == null) continue;
                        stopAsking = true;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                PolicyEditor.this.addNewCodebase(codebase);
            }
        });
    }

    public void removeCodebase(final String codebase) {
        if (codebase.equals(Translator.R("PEGlobalSettings")) || codebase.isEmpty()) {
            return;
        }
        int previousIndex = this.list.getSelectedIndex() - 1;
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        this.codebasePermissionsMap.remove(codebase);
        final int fIndex = previousIndex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.listModel.removeElement(codebase);
                PolicyEditor.this.list.setSelectedIndex(fIndex);
            }
        });
        this.changesMade = true;
    }

    public Set<String> getCodebases() {
        return new HashSet<String>(this.codebasePermissionsMap.keySet());
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissions(String codebase) {
        Map<PolicyEditorPermissions, Boolean> permissions = this.codebasePermissionsMap.get(codebase);
        if (permissions != null) {
            return new HashMap<PolicyEditorPermissions, Boolean>(permissions);
        }
        HashMap<PolicyEditorPermissions, Boolean> blank = new HashMap<PolicyEditorPermissions, Boolean>();
        for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            blank.put(perm, false);
        }
        return blank;
    }

    public Collection<CustomPermission> getCustomPermissions(String codebase) {
        Collection permissions = this.customPermissionsMap.get(codebase);
        if (permissions != null) {
            return new HashSet<CustomPermission>(permissions);
        }
        return Collections.emptySet();
    }

    private void updateCheckboxes(String codebase) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateCheckboxesImpl(codebase);
            } else {
                this.updateCheckboxesInvokeAndWait(codebase);
            }
        }
        catch (InterruptedException ex) {
            OutputController.getLogger().log(ex);
        }
        catch (InvocationTargetException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private void updateCheckboxesInvokeAndWait(final String codebase) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.updateCheckboxesImpl(codebase);
            }
        });
    }

    private void updateCheckboxesImpl(String codebase) {
        for (final PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            Boolean s;
            final JCheckBox box = this.checkboxMap.get((Object)perm);
            for (ActionListener l : box.getActionListeners()) {
                box.removeActionListener(l);
            }
            this.initializeMapForCodebase(codebase);
            final Map<PolicyEditorPermissions, Boolean> map = this.codebasePermissionsMap.get(codebase);
            boolean state = map != null ? ((s = map.get((Object)perm)) != null ? s : false) : false;
            for (JCheckBoxWithGroup jg : this.groupBoxList) {
                jg.setState(map);
            }
            box.setSelected(state);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PolicyEditor.this.changesMade = true;
                    map.put(perm, box.isSelected());
                    for (JCheckBoxWithGroup jg : PolicyEditor.this.groupBoxList) {
                        jg.setState(map);
                    }
                }
            });
        }
    }

    private static void setComponentMnemonic(AbstractButton component, String mnemonic) {
        int trig;
        try {
            trig = Integer.parseInt(mnemonic);
        }
        catch (NumberFormatException nfe) {
            OutputController.getLogger().log(nfe);
            return;
        }
        component.setMnemonic(trig);
    }

    private static JMenuBar createMenuBar(final Window window, PolicyEditor editor) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Translator.R("PEFileMenu"));
        PolicyEditor.setComponentMnemonic(fileMenu, Translator.R("PEFileMenuMnemonic"));
        JMenuItem openItem = new JMenuItem(Translator.R("PEOpenMenuItem"));
        PolicyEditor.setComponentMnemonic(openItem, Translator.R("PEOpenMenuItemMnemonic"));
        openItem.setAccelerator(KeyStroke.getKeyStroke(openItem.getMnemonic(), 2));
        openItem.addActionListener(editor.openButtonAction);
        fileMenu.add(openItem);
        JMenuItem saveItem = new JMenuItem(Translator.R("PESaveMenuItem"));
        PolicyEditor.setComponentMnemonic(saveItem, Translator.R("PESaveMenuItemMnemonic"));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(saveItem.getMnemonic(), 2));
        saveItem.addActionListener(editor.okButtonAction);
        fileMenu.add(saveItem);
        JMenuItem saveAsItem = new JMenuItem(Translator.R("PESaveAsMenuItem"));
        PolicyEditor.setComponentMnemonic(saveAsItem, Translator.R("PESaveAsMenuItemMnemonic"));
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(saveAsItem.getMnemonic(), 2));
        saveAsItem.addActionListener(editor.saveAsButtonAction);
        fileMenu.add(saveAsItem);
        JMenuItem exitItem = new JMenuItem(Translator.R("PEExitMenuItem"));
        PolicyEditor.setComponentMnemonic(exitItem, Translator.R("PEExitMenuItemMnemonic"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(exitItem.getMnemonic(), 2));
        exitItem.addActionListener(editor.closeButtonAction);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.dispose();
            }
        });
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        JMenu viewMenu = new JMenu(Translator.R("PEViewMenu"));
        PolicyEditor.setComponentMnemonic(viewMenu, Translator.R("PEViewMenuMnemonic"));
        JMenuItem customPermissionsItem = new JMenuItem(Translator.R("PECustomPermissionsItem"));
        PolicyEditor.setComponentMnemonic(customPermissionsItem, Translator.R("PECustomPermissionsItemMnemonic"));
        customPermissionsItem.setAccelerator(KeyStroke.getKeyStroke(customPermissionsItem.getMnemonic(), 8));
        customPermissionsItem.addActionListener(editor.viewCustomButtonAction);
        viewMenu.add(customPermissionsItem);
        menuBar.add(viewMenu);
        return menuBar;
    }

    private void setupLayout() {
        JLabel checkboxLabel = new JLabel();
        checkboxLabel.setText(Translator.R("PECheckboxLabel"));
        checkboxLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints checkboxLabelConstraints = new GridBagConstraints();
        checkboxLabelConstraints.gridx = 2;
        checkboxLabelConstraints.gridy = 0;
        checkboxLabelConstraints.fill = 2;
        this.add((Component)checkboxLabel, checkboxLabelConstraints);
        GridBagConstraints checkboxConstraints = new GridBagConstraints();
        checkboxConstraints.anchor = 21;
        checkboxConstraints.fill = 2;
        checkboxConstraints.weightx = 0.0;
        checkboxConstraints.weighty = 0.0;
        checkboxConstraints.gridx = 2;
        checkboxConstraints.gridy = 1;
        for (JCheckBox box : this.checkboxMap.values()) {
            if (PolicyEditorPermissions.Group.anyContains(box, this.checkboxMap)) continue;
            this.add((Component)box, checkboxConstraints);
            ++checkboxConstraints.gridx;
            if (checkboxConstraints.gridx <= 3) continue;
            checkboxConstraints.gridx = 2;
            ++checkboxConstraints.gridy;
        }
        for (PolicyEditorPermissions.Group g : PolicyEditorPermissions.Group.values()) {
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            final JCheckBoxWithGroup groupCh = new JCheckBoxWithGroup(g);
            this.groupBoxList.add(groupCh);
            final JPanel groupPanel = new JPanel(new GridBagLayout());
            groupPanel.setBorder(new LineBorder(Color.black));
            groupCh.setToolTipText(Translator.R("PEGrightClick"));
            groupCh.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        groupPanel.setVisible(!groupPanel.isVisible());
                        PolicyEditor.this.validate();
                        Container c = PolicyEditor.this.getParent();
                        while (!(c instanceof Window)) {
                            if (c == null) {
                                return;
                            }
                            c = c.getParent();
                        }
                        Window w = (Window)c;
                        w.pack();
                    }
                }
            });
            groupCh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String codebase = PolicyEditor.this.getSelectedCodebase();
                    if (codebase == null) {
                        return;
                    }
                    LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
                    for (ActionListener l : groupCh.getActionListeners()) {
                        backup.add(l);
                        groupCh.removeActionListener(l);
                    }
                    Map map = (Map)PolicyEditor.this.codebasePermissionsMap.get(codebase);
                    for (PolicyEditorPermissions p : groupCh.getGroup().getPermissions()) {
                        map.put(p, groupCh.isSelected());
                    }
                    PolicyEditor.this.changesMade = true;
                    PolicyEditor.this.updateCheckboxes(codebase);
                    for (ActionListener al : backup) {
                        groupCh.addActionListener(al);
                    }
                }
            });
            this.add((Component)groupCh, checkboxConstraints);
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            checkboxConstraints.gridwidth = 2;
            checkboxConstraints.fill = 1;
            this.add((Component)groupPanel, checkboxConstraints);
            GridBagConstraints groupCheckboxLabelConstraints = new GridBagConstraints();
            groupCheckboxLabelConstraints.anchor = 21;
            groupCheckboxLabelConstraints.weightx = 0.0;
            groupCheckboxLabelConstraints.weighty = 0.0;
            groupCheckboxLabelConstraints.gridx = 1;
            groupCheckboxLabelConstraints.gridy = 1;
            for (PolicyEditorPermissions p : g.getPermissions()) {
                groupPanel.add((Component)this.checkboxMap.get((Object)p), groupCheckboxLabelConstraints);
                ++groupCheckboxLabelConstraints.gridx;
                if (groupCheckboxLabelConstraints.gridx <= 2) continue;
                groupCheckboxLabelConstraints.gridx = 1;
                ++groupCheckboxLabelConstraints.gridy;
            }
            groupPanel.setVisible(false);
            checkboxConstraints.gridwidth = 1;
        }
        JLabel codebaseListLabel = new JLabel(Translator.R("PECodebaseLabel"));
        codebaseListLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints listLabelConstraints = new GridBagConstraints();
        listLabelConstraints.fill = 2;
        listLabelConstraints.gridx = 0;
        listLabelConstraints.gridy = 0;
        this.add((Component)codebaseListLabel, listLabelConstraints);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String codebase = PolicyEditor.this.getSelectedCodebase();
                if (codebase == null) {
                    return;
                }
                PolicyEditor.this.updateCheckboxes(codebase);
            }
        });
        this.list.setSelectionMode(0);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.list);
        GridBagConstraints listConstraints = new GridBagConstraints();
        listConstraints.fill = 1;
        listConstraints.weightx = 1.0;
        listConstraints.weighty = 1.0;
        listConstraints.gridheight = checkboxConstraints.gridy + 1;
        listConstraints.gridwidth = 2;
        listConstraints.gridx = 0;
        listConstraints.gridy = 1;
        this.add((Component)this.scrollPane, listConstraints);
        GridBagConstraints addCodebaseButtonConstraints = new GridBagConstraints();
        addCodebaseButtonConstraints.fill = 2;
        addCodebaseButtonConstraints.gridx = 0;
        addCodebaseButtonConstraints.gridy = listConstraints.gridy + listConstraints.gridheight + 1;
        PolicyEditor.setComponentMnemonic(this.addCodebaseButton, Translator.R("PEAddCodebaseMnemonic"));
        this.add((Component)this.addCodebaseButton, addCodebaseButtonConstraints);
        GridBagConstraints removeCodebaseButtonConstraints = new GridBagConstraints();
        removeCodebaseButtonConstraints.fill = 2;
        removeCodebaseButtonConstraints.gridx = addCodebaseButtonConstraints.gridx + 1;
        removeCodebaseButtonConstraints.gridy = addCodebaseButtonConstraints.gridy;
        PolicyEditor.setComponentMnemonic(this.removeCodebaseButton, Translator.R("PERemoveCodebaseMnemonic"));
        this.removeCodebaseButton.setPreferredSize(this.addCodebaseButton.getPreferredSize());
        this.add((Component)this.removeCodebaseButton, removeCodebaseButtonConstraints);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.fill = 2;
        okButtonConstraints.gridx = removeCodebaseButtonConstraints.gridx + 2;
        okButtonConstraints.gridy = removeCodebaseButtonConstraints.gridy;
        PolicyEditor.setComponentMnemonic(this.okButton, Translator.R("PEOkButtonMnemonic"));
        this.add((Component)this.okButton, okButtonConstraints);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.fill = 2;
        cancelButtonConstraints.gridx = okButtonConstraints.gridx + 1;
        cancelButtonConstraints.gridy = okButtonConstraints.gridy;
        PolicyEditor.setComponentMnemonic(this.closeButton, Translator.R("PECancelButtonMnemonic"));
        this.add((Component)this.closeButton, cancelButtonConstraints);
        this.setMinimumSize(this.getPreferredSize());
    }

    void updateCustomPermissions(String codebase, Collection<CustomPermission> permissions) {
        this.changesMade = true;
        this.customPermissionsMap.get(codebase).clear();
        this.customPermissionsMap.get(codebase).addAll(permissions);
    }

    private void resetCodebases() {
        this.listModel.clear();
        this.codebasePermissionsMap.clear();
        this.customPermissionsMap.clear();
        this.initializeMapForCodebase("");
        this.listModel.addElement(Translator.R("PEGlobalSettings"));
        this.list.setSelectedValue(Translator.R("PEGlobalSettings"), true);
        this.updateCheckboxes("");
    }

    private void openAndParsePolicyFile() {
        new Thread(){

            @Override
            public void run() {
                FileLock fileLock;
                String contents;
                FileUtils.OpenFileResult ofr;
                PolicyEditor.this.resetCodebases();
                if (!PolicyEditor.this.file.exists()) {
                    try {
                        PolicyEditor.this.file.createNewFile();
                    }
                    catch (IOException e) {
                        OutputController.getLogger().log(e);
                    }
                }
                if ((ofr = FileUtils.testFilePermissions(PolicyEditor.this.file)) == FileUtils.OpenFileResult.FAILURE || ofr == FileUtils.OpenFileResult.NOT_FILE) {
                    FileUtils.showCouldNotOpenFilepathDialog((Component)PolicyEditor.this.weakThis.get(), PolicyEditor.this.file.getPath());
                    return;
                }
                if (ofr == FileUtils.OpenFileResult.CANT_WRITE) {
                    FileUtils.showReadOnlyDialog((Component)PolicyEditor.this.weakThis.get());
                }
                try {
                    PolicyEditor.this.fileWatcher = new MD5SumWatcher(PolicyEditor.this.file);
                    PolicyEditor.this.fileWatcher.update();
                    contents = FileUtils.loadFileAsString(PolicyEditor.this.file);
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantOpenFile", PolicyEditor.this.file.getPath()));
                    FileUtils.showCouldNotOpenDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PECouldNotOpen"));
                    return;
                }
                PolicyEditor.this.codebasePermissionsMap.clear();
                PolicyEditor.this.customPermissionsMap.clear();
                String[] lines = contents.split("\\r?\\n+");
                String codebase = "";
                try {
                    fileLock = FileUtils.getFileLock(PolicyEditor.this.file.getAbsolutePath(), false, true);
                }
                catch (FileNotFoundException e) {
                    OutputController.getLogger().log(e);
                    FileUtils.showCouldNotOpenDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PECouldNotOpen"));
                    return;
                }
                boolean openBlock = false;
                boolean commentBlock = false;
                for (String line : lines) {
                    Pattern openBlockPattern = Pattern.compile("grant\\s*\"?\\s*(?:codeBase)?\\s*\"?([^\"\\s]*)\"?\\s*\\{");
                    Matcher openBlockMatcher = openBlockPattern.matcher(line);
                    if (openBlockMatcher.matches()) {
                        codebase = openBlockMatcher.group(1);
                        PolicyEditor.this.initializeMapForCodebase(codebase);
                        PolicyEditor.this.listModel.addElement(codebase);
                        openBlock = true;
                    }
                    boolean commentLine = false;
                    if (line.matches("\\s*\\};\\s*")) {
                        openBlock = false;
                    }
                    if (line.matches(".*/\\*.*")) {
                        commentBlock = true;
                    }
                    if (line.matches(".*\\*/.*")) {
                        commentBlock = false;
                    }
                    if (line.matches(".*/\\*.*") && line.matches(".*\\*/.*")) {
                        commentLine = true;
                    }
                    if (line.matches("\\s*//.*")) {
                        commentLine = true;
                    }
                    if (!openBlock || commentBlock || commentLine) continue;
                    PolicyEditorPermissions perm = PolicyEditorPermissions.fromString(line);
                    if (perm != null) {
                        ((Map)PolicyEditor.this.codebasePermissionsMap.get(codebase)).put(perm, true);
                        PolicyEditor.this.updateCheckboxes(codebase);
                        continue;
                    }
                    CustomPermission cPerm = CustomPermission.fromString(line.trim());
                    if (cPerm == null) continue;
                    ((Set)PolicyEditor.this.customPermissionsMap.get(codebase)).add(cPerm);
                }
                PolicyEditor.this.list.setSelectedValue(Translator.R("PEGlobalSettings"), true);
                PolicyEditor.this.updateCheckboxes("");
                try {
                    fileLock.release();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                }
            }
        }.run();
    }

    private boolean initializeMapForCodebase(String codebase) {
        if (this.codebasePermissionsMap.containsKey(codebase) || this.customPermissionsMap.containsKey(codebase)) {
            return true;
        }
        if (this.codebasePermissionsMap.get(codebase) == null) {
            HashMap<PolicyEditorPermissions, Boolean> map = new HashMap<PolicyEditorPermissions, Boolean>();
            for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
                map.put(perm, false);
            }
            this.codebasePermissionsMap.put(codebase, map);
        }
        if (this.customPermissionsMap.get(codebase) == null) {
            HashSet set = new HashSet();
            this.customPermissionsMap.put(codebase, set);
        }
        return false;
    }

    private void savePolicyFile() {
        if (!this.changesMade) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int response = PolicyEditor.this.updateMd5WithDialog();
                    switch (response) {
                        case 0: {
                            PolicyEditor.this.openAndParsePolicyFile();
                            return;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    OutputController.getLogger().log(e);
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    PolicyEditor.this.showCouldNotSaveDialog();
                    return;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(PolicyEditor.AUTOGENERATED_NOTICE);
                sb.append("\n/* Generated by PolicyEditor at ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime())).append(" */").append(System.getProperty("line.separator"));
                HashSet<PolicyEditorPermissions> enabledPermissions = new HashSet<PolicyEditorPermissions>();
                FileLock fileLock = null;
                try {
                    fileLock = FileUtils.getFileLock(PolicyEditor.this.file.getAbsolutePath(), false, true);
                    for (String codebase : PolicyEditor.this.codebasePermissionsMap.keySet()) {
                        enabledPermissions.clear();
                        for (Map.Entry entry : ((Map)PolicyEditor.this.codebasePermissionsMap.get(codebase)).entrySet()) {
                            if (!((Boolean)entry.getValue()).booleanValue()) continue;
                            enabledPermissions.add((PolicyEditorPermissions)((Object)entry.getKey()));
                        }
                        sb.append(new PolicyEntry(codebase, enabledPermissions, (Collection)PolicyEditor.this.customPermissionsMap.get(codebase)).toString());
                    }
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                }
                finally {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (IOException e) {
                            OutputController.getLogger().log(e);
                        }
                    }
                }
                try {
                    FileUtils.saveFile(sb.toString(), PolicyEditor.this.file);
                    if (PolicyEditor.this.fileWatcher == null) {
                        PolicyEditor.this.fileWatcher = new MD5SumWatcher(PolicyEditor.this.file);
                    }
                    PolicyEditor.this.fileWatcher.update();
                    PolicyEditor.this.changesMade = false;
                    PolicyEditor.this.showChangesSavedDialog();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantWriteFile", PolicyEditor.this.file.getPath()));
                    PolicyEditor.this.showCouldNotSaveDialog();
                }
            }
        }.run();
    }

    private void showChangesSavedDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PEChangesSaved"));
            }
        });
    }

    private void showCouldNotSaveDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.weakThis.get(), Translator.R("PECouldNotSave"), Translator.R("Error"), 0);
            }
        });
    }

    public int updateMd5WithDialog() throws FileNotFoundException, IOException {
        if (this.fileWatcher == null) {
            if (this.file != null) {
                this.fileWatcher = new MD5SumWatcher(this.file);
            }
            return 1;
        }
        boolean changed = this.fileWatcher.update();
        if (changed) {
            return JOptionPane.showConfirmDialog((Component)this.weakThis.get(), Translator.R("PEFileModifiedDetail", this.file.getCanonicalPath()), Translator.R("PEFileModified"), 1);
        }
        return 1;
    }

    public static void main(final String[] args) {
        final Map<String, String> argsMap = PolicyEditor.argsToMap(args);
        if (argsMap.containsKey(HELP_FLAG)) {
            System.out.println(HELP_MESSAGE);
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String filepath = (String)argsMap.get(PolicyEditor.FILE_FLAG);
                if (filepath == null && args.length == 1) {
                    filepath = args[0];
                }
                PolicyEditorWindow frame = PolicyEditor.getPolicyEditorFrame(filepath);
                frame.asWindow().setVisible(true);
                String codebaseStr = (String)argsMap.get(PolicyEditor.CODEBASE_FLAG);
                if (codebaseStr != null) {
                    String[] urls = codebaseStr.split(" ");
                    frame.getPolicyEditor().addNewCodebases(urls);
                }
            }
        });
    }

    public static PolicyEditor createInstance(String filepath) {
        return new PolicyEditor(filepath);
    }

    static Map<String, String> argsToMap(String[] args) {
        List<String> argsList = Arrays.asList(args);
        HashMap<String, String> map = new HashMap<String, String>();
        if (argsList.contains(HELP_FLAG)) {
            map.put(HELP_FLAG, null);
        }
        if (argsList.contains(FILE_FLAG)) {
            map.put(FILE_FLAG, argsList.get(argsList.indexOf(FILE_FLAG) + 1));
        }
        if (argsList.contains(CODEBASE_FLAG)) {
            String str;
            int flagIndex = argsList.indexOf(CODEBASE_FLAG);
            StringBuilder sb = new StringBuilder();
            for (int i = flagIndex + 1; !(i >= argsList.size() || (str = argsList.get(i)).equals(HELP_FLAG) || str.equals(CODEBASE_FLAG) || str.equals(FILE_FLAG)); ++i) {
                sb.append(str);
                sb.append(" ");
            }
            map.put(CODEBASE_FLAG, sb.toString().trim());
        }
        return map;
    }

    private static class PolicyEditorDialog
    extends JDialog
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorDialog(PolicyEditor editor) {
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
            super.setModalityType(type);
        }

        @Override
        public void quit() {
            if (this.editor.changesMade) {
                int save = JOptionPane.showConfirmDialog(this, Translator.R("PESaveChanges"));
                if (save == 0) {
                    if (this.editor.file == null) {
                        int choice = this.editor.fileChooser.showSaveDialog(this);
                        if (choice == 0) {
                            this.editor.file = this.editor.fileChooser.getSelectedFile();
                        } else if (choice == 1) {
                            return;
                        }
                    }
                    this.editor.savePolicyFile();
                } else if (save == 2) {
                    return;
                }
            }
            this.editor.weakThis.clear();
            this.editor.setClosed();
            this.dispose();
        }
    }

    private static class PolicyEditorFrame
    extends JFrame
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorFrame(PolicyEditor editor) {
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
        }

        @Override
        public void quit() {
            if (this.editor.changesMade) {
                int save = JOptionPane.showConfirmDialog(this, Translator.R("PESaveChanges"));
                if (save == 0) {
                    if (this.editor.file == null) {
                        int choice = this.editor.fileChooser.showSaveDialog(this);
                        if (choice == 0) {
                            this.editor.file = this.editor.fileChooser.getSelectedFile();
                        } else if (choice == 1) {
                            return;
                        }
                    }
                    this.editor.savePolicyFile();
                } else if (save == 2) {
                    return;
                }
            }
            this.editor.weakThis.clear();
            this.editor.setClosed();
            this.dispose();
        }
    }

    public static interface PolicyEditorWindow {
        public void setTitle(String var1);

        public void setDefaultCloseOperation(int var1);

        public PolicyEditor getPolicyEditor();

        public void setPolicyEditor(PolicyEditor var1);

        public void setJMenuBar(JMenuBar var1);

        public Window asWindow();

        public void setModalityType(Dialog.ModalityType var1);

        public void quit();
    }

    private static class JCheckBoxWithGroup
    extends JCheckBox {
        private final PolicyEditorPermissions.Group group;

        private JCheckBoxWithGroup(PolicyEditorPermissions.Group g) {
            super(g.getTitle());
            this.group = g;
        }

        public PolicyEditorPermissions.Group getGroup() {
            return this.group;
        }

        private void setState(Map<PolicyEditorPermissions, Boolean> map) {
            LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
            for (ActionListener l : this.getActionListeners()) {
                backup.add(l);
                this.removeActionListener(l);
            }
            int i = this.group.getState(map);
            this.setBackground(this.getParent().getBackground());
            if (i > 0) {
                this.setSelected(true);
            }
            if (i < 0) {
                this.setSelected(false);
            }
            if (i == 0) {
                this.setBackground(Color.yellow);
                this.setSelected(false);
            }
            for (ActionListener al : backup) {
                this.addActionListener(al);
            }
        }
    }
}

