/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;

public class CustomPolicyViewer
extends JFrame {
    private final Collection<CustomPermission> customPermissions = new TreeSet<CustomPermission>();
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList list = new JList(this.listModel);
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JLabel listLabel = new JLabel();
    private final ActionListener addButtonAction;
    private final ActionListener removeButtonAction;
    private final ActionListener closeButtonAction;
    private final WeakReference<CustomPolicyViewer> weakThis = new WeakReference<CustomPolicyViewer>(this);

    public CustomPolicyViewer(final PolicyEditor parent, final String codebase, Collection<CustomPermission> permissions) {
        this.setLayout(new GridBagLayout());
        this.setTitle(Translator.R("PECPTitle"));
        this.customPermissions.addAll(permissions);
        for (CustomPermission perm : this.customPermissions) {
            this.listModel.addElement(perm);
        }
        this.addButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prefill = Translator.R("PECPType") + " " + Translator.R("PECPTarget") + " [" + Translator.R("PECPActions") + "]";
                String string = JOptionPane.showInputDialog((Component)CustomPolicyViewer.this.weakThis.get(), Translator.R("PECPPrompt"), prefill);
                if (string == null || string.isEmpty()) {
                    return;
                }
                String[] parts = string.split(" ");
                if (parts.length < 2) {
                    return;
                }
                String type = parts[0];
                String target = parts[1];
                String actions = parts.length > 2 ? parts[2] : "";
                CustomPermission perm = new CustomPermission(type, target, actions);
                if (perm != null) {
                    CustomPolicyViewer.this.customPermissions.add(perm);
                    CustomPolicyViewer.this.listModel.addElement(perm);
                    parent.updateCustomPermissions(codebase, CustomPolicyViewer.this.customPermissions);
                }
            }
        };
        this.addButton.setText(Translator.R("PECPAddButton"));
        this.addButton.addActionListener(this.addButtonAction);
        this.removeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomPolicyViewer.this.list.getSelectedValue() == null) {
                    return;
                }
                CustomPolicyViewer.this.customPermissions.remove(CustomPolicyViewer.this.list.getSelectedValue());
                CustomPolicyViewer.this.listModel.removeElement(CustomPolicyViewer.this.list.getSelectedValue());
                parent.updateCustomPermissions(codebase, CustomPolicyViewer.this.customPermissions);
            }
        };
        this.removeButton.setText(Translator.R("PECPRemoveButton"));
        this.removeButton.addActionListener(this.removeButtonAction);
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPolicyViewer.this.weakThis.clear();
                parent.customPolicyViewerClosing();
                CustomPolicyViewer.this.dispose();
            }
        };
        this.closeButton.setText(Translator.R("PECPCloseButton"));
        this.closeButton.addActionListener(this.closeButtonAction);
        String codebaseText = codebase.trim().isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
        this.listLabel.setText(Translator.R("PECPListLabel", codebaseText));
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.list.setSelectedIndex(0);
        this.setupLayout();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CustomPolicyViewer.this.weakThis.clear();
                parent.customPolicyViewerClosing();
                CustomPolicyViewer.this.dispose();
            }
        });
    }

    private void setupLayout() {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
        this.listLabel.setBorder(border);
        this.add((Component)this.listLabel, labelConstraints);
        GridBagConstraints scrollPaneConstraints = new GridBagConstraints();
        scrollPaneConstraints.gridx = 0;
        scrollPaneConstraints.gridy = 1;
        scrollPaneConstraints.weightx = 1.0;
        scrollPaneConstraints.weighty = 1.0;
        scrollPaneConstraints.gridwidth = 3;
        scrollPaneConstraints.fill = 1;
        this.list.setSelectionMode(0);
        this.scrollPane.setViewportView(this.list);
        this.add((Component)this.scrollPane, scrollPaneConstraints);
        GridBagConstraints addButtonConstraints = new GridBagConstraints();
        addButtonConstraints.gridx = 0;
        addButtonConstraints.gridy = scrollPaneConstraints.gridy + 1;
        addButtonConstraints.fill = 2;
        this.add((Component)this.addButton, addButtonConstraints);
        GridBagConstraints removeButtonConstraints = new GridBagConstraints();
        removeButtonConstraints.gridx = addButtonConstraints.gridx + 1;
        removeButtonConstraints.gridy = addButtonConstraints.gridy;
        removeButtonConstraints.fill = 2;
        this.add((Component)this.removeButton, removeButtonConstraints);
        GridBagConstraints closeButtonConstraints = new GridBagConstraints();
        closeButtonConstraints.gridx = removeButtonConstraints.gridx + 1;
        closeButtonConstraints.gridy = removeButtonConstraints.gridy;
        closeButtonConstraints.fill = 2;
        this.add((Component)this.closeButton, closeButtonConstraints);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }
}

