/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.DirectoryValidator;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class DeploymentConfiguration {
    public static final String DEPLOYMENT_SUBDIR_DIR = "icedtea-web";
    public static final String DEPLOYMENT_CACHE_DIR = ".cache" + File.separator + "icedtea-web";
    public static final String DEPLOYMENT_CONFIG_DIR = ".config" + File.separator + "icedtea-web";
    public static final String DEPLOYMENT_CONFIG_FILE = "deployment.config";
    public static final String DEPLOYMENT_PROPERTIES = "deployment.properties";
    public static final String APPLET_TRUST_SETTINGS = ".appletTrustSettings";
    public static final String DEPLOYMENT_COMMENT = "Netx deployment configuration";
    public static final int JNLP_ASSOCIATION_NEVER = 0;
    public static final int JNLP_ASSOCIATION_NEW_ONLY = 1;
    public static final int JNLP_ASSOCIATION_ASK_USER = 2;
    public static final int JNLP_ASSOCIATION_REPLACE_ASK = 3;
    public static final String CONSOLE_HIDE = "HIDE";
    public static final String CONSOLE_SHOW = "SHOW";
    public static final String CONSOLE_DISABLE = "DISABLE";
    public static final String CONSOLE_SHOW_PLUGIN = "SHOW_PLUGIN_ONLY";
    public static final String CONSOLE_SHOW_JAVAWS = "SHOW_JAVAWS_ONLY";
    public static final String KEY_USER_CACHE_DIR = "deployment.user.cachedir";
    public static final String KEY_USER_PERSISTENCE_CACHE_DIR = "deployment.user.pcachedir";
    public static final String KEY_SYSTEM_CACHE_DIR = "deployment.system.cachedir";
    public static final String KEY_USER_LOG_DIR = "deployment.user.logdir";
    public static final String KEY_USER_TMP_DIR = "deployment.user.tmp";
    public static final String KEY_USER_LOCKS_DIR = "deployment.user.locksdir";
    public static final String KEY_USER_NETX_RUNNING_FILE = "deployment.user.runningfile";
    public static final String KEY_USER_SECURITY_POLICY = "deployment.user.security.policy";
    public static final String KEY_USER_TRUSTED_CA_CERTS = "deployment.user.security.trusted.cacerts";
    public static final String KEY_USER_TRUSTED_JSSE_CA_CERTS = "deployment.user.security.trusted.jssecacerts";
    public static final String KEY_USER_TRUSTED_CERTS = "deployment.user.security.trusted.certs";
    public static final String KEY_USER_TRUSTED_JSSE_CERTS = "deployment.user.security.trusted.jssecerts";
    public static final String KEY_USER_TRUSTED_CLIENT_CERTS = "deployment.user.security.trusted.clientauthcerts";
    public static final String KEY_SYSTEM_SECURITY_POLICY = "deployment.system.security.policy";
    public static final String KEY_SYSTEM_TRUSTED_CA_CERTS = "deployment.system.security.cacerts";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CA_CERTS = "deployment.system.security.jssecacerts";
    public static final String KEY_SYSTEM_TRUSTED_CERTS = "deployment.system.security.trusted.certs";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CERTS = "deployment.system.security.trusted.jssecerts";
    public static final String KEY_SYSTEM_TRUSTED_CLIENT_CERTS = "deployment.system.security.trusted.clientautcerts";
    public static final String KEY_SECURITY_PROMPT_USER = "deployment.security.askgrantdialog.show";
    public static final String KEY_SECURITY_LEVEL = "deployment.security.level";
    public static final String KEY_SECURITY_TRUSTED_POLICY = "deployment.security.trusted.policy";
    public static final String KEY_SECURITY_ALLOW_HIDE_WINDOW_WARNING = "deployment.security.sandbox.awtwarningwindow";
    public static final String KEY_SECURITY_PROMPT_USER_FOR_JNLP = "deployment.security.sandbox.jnlp.enhanced";
    public static final String KEY_SECURITY_INSTALL_AUTHENTICATOR = "deployment.security.authenticator";
    public static final String KEY_PROXY_TYPE = "deployment.proxy.type";
    public static final String KEY_PROXY_SAME = "deployment.proxy.same";
    public static final String KEY_PROXY_AUTO_CONFIG_URL = "deployment.proxy.auto.config.url";
    public static final String KEY_PROXY_BYPASS_LIST = "deployment.proxy.bypass.list";
    public static final String KEY_PROXY_BYPASS_LOCAL = "deployment.proxy.bypass.local";
    public static final String KEY_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String KEY_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String KEY_PROXY_HTTPS_HOST = "deployment.proxy.https.host";
    public static final String KEY_PROXY_HTTPS_PORT = "deployment.proxy.https.port";
    public static final String KEY_PROXY_FTP_HOST = "deployment.proxy.ftp.host";
    public static final String KEY_PROXY_FTP_PORT = "deployment.proxy.ftp.port";
    public static final String KEY_PROXY_SOCKS4_HOST = "deployment.proxy.socks.host";
    public static final String KEY_PROXY_SOCKS4_PORT = "deployment.proxy.socks.port";
    public static final String KEY_PROXY_OVERRIDE_HOSTS = "deployment.proxy.override.hosts";
    public static final String KEY_ENABLE_LOGGING = "deployment.log";
    public static final String KEY_ENABLE_LOGGING_HEADERS = "deployment.log.headers";
    public static final String KEY_ENABLE_LOGGING_TOFILE = "deployment.log.file";
    public static final String KEY_ENABLE_LOGGING_TOSTREAMS = "deployment.log.stdstreams";
    public static final String KEY_ENABLE_LOGGING_TOSYSTEMLOG = "deployment.log.system";
    public static final String KEY_ENABLE_MANIFEST_ATTRIBUTES_CHECK = "deployment.manifest.attributes.check";
    public static final String KEY_CONSOLE_STARTUP_MODE = "deployment.console.startup.mode";
    public static final String KEY_JNLP_ASSOCIATIONS = "deployment.javaws.associations";
    public static final String KEY_CREATE_DESKTOP_SHORTCUT = "deployment.javaws.shortcut";
    public static final String KEY_JRE_INTSTALL_URL = "deployment.javaws.installURL";
    public static final String KEY_AUTO_DOWNLOAD_JRE = "deployment.javaws.autodownload";
    public static final String KEY_BROWSER_PATH = "deployment.browser.path";
    public static final String KEY_UPDATE_TIMEOUT = "deployment.javaws.update.timeout";
    public static final String KEY_PLUGIN_JVM_ARGUMENTS = "deployment.plugin.jvm.arguments";
    public static final String KEY_JRE_DIR = "deployment.jre.dir";
    private ConfigurationException loadingException = null;
    private boolean systemPropertiesMandatory = false;
    private File systemPropertiesFile = null;
    private File userPropertiesFile = null;
    public static final File USER_DEPLOYMENT_PROPERTIES_FILE = new File(Defaults.USER_CONFIG_HOME + File.separator + "deployment.properties");
    private Map<String, Setting<String>> currentConfiguration = new HashMap<String, Setting<String>>();
    private Map<String, Setting<String>> unchangeableConfiguration = new HashMap<String, Setting<String>>();

    public void setLoadingException(ConfigurationException ex) {
        this.loadingException = ex;
    }

    public ConfigurationException getLoadingException() {
        return this.loadingException;
    }

    public void resetToDefaults() {
        this.currentConfiguration = Defaults.getDefaults();
    }

    public void load() throws ConfigurationException {
        this.load(true);
    }

    public static File getAppletTrustUserSettingsPath() {
        return new File(Defaults.USER_CONFIG_HOME + File.separator + APPLET_TRUST_SETTINGS);
    }

    public static File getAppletTrustGlobalSettingsPath() {
        return new File(File.separator + "etc" + File.separator + ".java" + File.separator + "deployment" + File.separator + APPLET_TRUST_SETTINGS);
    }

    public void load(boolean fixIssues) throws ConfigurationException {
        File userFile = new File(USER_DEPLOYMENT_PROPERTIES_FILE.getAbsolutePath());
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(userFile.toString());
        }
        File systemConfigFile = this.findSystemConfigFile();
        this.load(systemConfigFile, userFile, fixIssues);
    }

    void load(File systemConfigFile, File userFile, boolean fixIssues) throws ConfigurationException {
        Map<String, Setting<String>> initialProperties = Defaults.getDefaults();
        Map<String, Setting<String>> systemProperties = null;
        if (systemConfigFile != null) {
            if (this.loadSystemConfiguration(systemConfigFile)) {
                OutputController.getLogger().log("System level deployment.config is mandatory: " + this.systemPropertiesMandatory);
                systemProperties = this.loadProperties(ConfigType.System, this.systemPropertiesFile, this.systemPropertiesMandatory);
            }
            if (systemProperties != null) {
                this.mergeMaps(initialProperties, systemProperties);
            }
        }
        this.unchangeableConfiguration = new HashMap<String, Setting<String>>();
        Set<String> keys = initialProperties.keySet();
        for (String key : keys) {
            this.unchangeableConfiguration.put(key, new Setting<String>(initialProperties.get(key)));
        }
        this.userPropertiesFile = userFile;
        Map<String, Setting<String>> userProperties = this.loadProperties(ConfigType.User, this.userPropertiesFile, false);
        if (userProperties != null) {
            this.mergeMaps(initialProperties, userProperties);
        }
        if (fixIssues) {
            this.checkAndFixConfiguration(initialProperties);
        }
        this.currentConfiguration = initialProperties;
    }

    public void copyTo(Properties target) {
        Set<String> names = this.getAllPropertyNames();
        for (String name : names) {
            String value = this.getProperty(name);
            if (value == null) continue;
            target.setProperty(name, value);
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkRead(this.userPropertiesFile.toString());
        }
        String value = null;
        if (this.currentConfiguration.get(key) != null) {
            value = this.currentConfiguration.get(key).getValue();
        }
        return value;
    }

    public Set<String> getAllPropertyNames() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration.keySet();
    }

    public Map<String, Setting<String>> getRaw() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration;
    }

    public void setProperty(String key, String value) {
        Setting<String> currentValue;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.userPropertiesFile != null) {
            sm.checkWrite(this.userPropertiesFile.toString());
        }
        if ((currentValue = this.currentConfiguration.get(key)) != null) {
            if (!currentValue.isLocked()) {
                currentValue.setValue(value);
            }
        } else {
            currentValue = new Setting<String>(key, Translator.R("Unknown"), false, null, null, value, Translator.R("Unknown"));
            this.currentConfiguration.put(key, currentValue);
        }
    }

    public void checkAndFixConfiguration(Map<String, Setting<String>> initial) {
        Map<String, Setting<String>> defaults = Defaults.getDefaults();
        for (String key : initial.keySet()) {
            Setting<String> s = initial.get(key);
            if (!s.getName().equals(key)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCInternal", "key " + key + " does not match setting name " + s.getName()));
                continue;
            }
            if (!defaults.containsKey(key)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCUnknownSettingWithName", key));
                continue;
            }
            ValueValidator checker = defaults.get(key).getValidator();
            if (checker == null) continue;
            try {
                checker.validate(s.getValue());
            }
            catch (IllegalArgumentException e) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCIncorrectValue", key, s.getValue(), checker.getPossibleValues()));
                s.setValue(s.getDefaultValue());
                OutputController.getLogger().log(e);
            }
        }
    }

    private File findSystemConfigFile() {
        File etcFile = new File(File.separator + "etc" + File.separator + ".java" + File.separator + "deployment" + File.separator + DEPLOYMENT_CONFIG_FILE);
        if (etcFile.isFile()) {
            return etcFile;
        }
        String jrePath = null;
        try {
            Map<String, Setting<String>> tmpProperties = this.parsePropertiesFile(USER_DEPLOYMENT_PROPERTIES_FILE);
            Setting<String> jreSetting = tmpProperties.get(KEY_JRE_DIR);
            if (jreSetting != null) {
                jrePath = jreSetting.getValue();
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        File jreFile = jrePath != null ? new File(jrePath + File.separator + "lib" + File.separator + DEPLOYMENT_CONFIG_FILE) : new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + DEPLOYMENT_CONFIG_FILE);
        if (jreFile.isFile()) {
            return jreFile;
        }
        return null;
    }

    private boolean loadSystemConfiguration(File configFile) throws ConfigurationException {
        OutputController.getLogger().log("Loading system configuation from: " + configFile);
        Map<Object, Object> systemConfiguration = new HashMap();
        try {
            systemConfiguration = this.parsePropertiesFile(configFile);
        }
        catch (IOException e) {
            OutputController.getLogger().log("No System level deployment.config found.");
            OutputController.getLogger().log(e);
            return false;
        }
        String urlString = null;
        try {
            Setting urlSettings = (Setting)systemConfiguration.get("deployment.system.config");
            if (urlSettings == null || urlSettings.getValue() == null) {
                OutputController.getLogger().log("No System level deployment.properties found in " + configFile.getAbsolutePath());
                return false;
            }
            urlString = (String)urlSettings.getValue();
            Setting mandatory = (Setting)systemConfiguration.get("deployment.system.config.mandatory");
            this.systemPropertiesMandatory = Boolean.valueOf(mandatory == null ? null : (String)mandatory.getValue());
            OutputController.getLogger().log("System level settings deployment.properties are mandatory:" + this.systemPropertiesMandatory);
            URL url = new URL(urlString);
            if (url.getProtocol().equals("file")) {
                this.systemPropertiesFile = new File(url.getFile());
                OutputController.getLogger().log("Using System leveldeployment.properties: " + this.systemPropertiesFile);
                return true;
            }
            OutputController.getLogger().log("Remote + deployment.properties not supported: " + urlString + "in " + configFile.getAbsolutePath());
            return false;
        }
        catch (MalformedURLException e) {
            OutputController.getLogger().log("Invalid url for deployment.properties: " + urlString + "in " + configFile.getAbsolutePath());
            OutputController.getLogger().log(e);
            if (this.systemPropertiesMandatory) {
                ConfigurationException ce = new ConfigurationException("Invalid url to system properties, which are mandatory");
                ce.initCause(e);
                throw ce;
            }
            return false;
        }
    }

    private Map<String, Setting<String>> loadProperties(ConfigType type, File file, boolean mandatory) throws ConfigurationException {
        if (file == null || !file.isFile()) {
            OutputController.getLogger().log("No " + type.toString() + " level " + DEPLOYMENT_PROPERTIES + " found.");
            if (!mandatory) {
                return null;
            }
            throw new ConfigurationException();
        }
        OutputController.getLogger().log("Loading " + type.toString() + " level properties from: " + file);
        try {
            return this.parsePropertiesFile(file);
        }
        catch (IOException e) {
            if (mandatory) {
                ConfigurationException ce = new ConfigurationException("Exception during loading of " + file + " which is mandatory to read");
                ce.initCause(e);
                throw ce;
            }
            OutputController.getLogger().log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.userPropertiesFile == null) {
            throw new IllegalStateException("must load() before save()");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkWrite(this.userPropertiesFile.toString());
        }
        OutputController.getLogger().log("Saving properties into " + this.userPropertiesFile.toString());
        Properties toSave = new Properties();
        for (String key : this.currentConfiguration.keySet()) {
            String newValue;
            String oldValue = this.unchangeableConfiguration.get(key) == null ? null : this.unchangeableConfiguration.get(key).getValue();
            String string = newValue = this.currentConfiguration.get(key) == null ? null : this.currentConfiguration.get(key).getValue();
            if (oldValue == null && newValue == null) continue;
            if (oldValue == null && newValue != null) {
                toSave.setProperty(key, newValue);
                continue;
            }
            if (oldValue != null && newValue == null) {
                toSave.setProperty(key, newValue);
                continue;
            }
            if (oldValue.equals(newValue)) continue;
            toSave.setProperty(key, newValue);
        }
        File backupPropertiesFile = new File(this.userPropertiesFile.toString() + ".old");
        if (this.userPropertiesFile.isFile() && !this.userPropertiesFile.renameTo(backupPropertiesFile)) {
            throw new IOException("Error saving backup copy of " + this.userPropertiesFile);
        }
        FileUtils.createParentDir(this.userPropertiesFile);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.userPropertiesFile));
        try {
            toSave.store(out, DEPLOYMENT_COMMENT);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Setting<String>> parsePropertiesFile(File propertiesFile) throws IOException {
        HashMap<String, Setting<String>> result = new HashMap<String, Setting<String>>();
        Properties properties = new Properties();
        BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
        try {
            properties.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            Setting configValue;
            if (key.endsWith(".locked")) {
                String realKey = key.substring(0, key.length() - ".locked".length());
                configValue = (Setting)result.get(realKey);
                if (configValue == null) {
                    configValue = new Setting<Object>(realKey, Translator.R("Unknown"), true, null, null, null, propertiesFile.toString());
                    result.put(realKey, configValue);
                    continue;
                }
                configValue.setLocked(true);
                continue;
            }
            String newValue = properties.getProperty(key);
            configValue = (Setting)result.get(key);
            if (configValue == null) {
                configValue = new Setting(key, Translator.R("Unknown"), false, null, null, newValue, propertiesFile.toString());
                result.put(key, configValue);
                continue;
            }
            configValue.setValue(newValue);
            configValue.setSource(propertiesFile.toString());
        }
        return result;
    }

    private void mergeMaps(Map<String, Setting<String>> finalMap, Map<String, Setting<String>> srcMap) {
        for (String key : srcMap.keySet()) {
            Setting<String> destValue = finalMap.get(key);
            Setting<String> srcValue = srcMap.get(key);
            if (destValue == null) {
                finalMap.put(key, srcValue);
                continue;
            }
            if (destValue.isLocked()) continue;
            destValue.setSource(srcValue.getSource());
            destValue.setValue(srcValue.getValue());
        }
    }

    private static void dumpConfiguration(Map<String, Setting<String>> config, PrintStream out) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "KEY: VALUE [Locked]");
        for (String key : config.keySet()) {
            Setting<String> value = config.get(key);
            out.println("'" + key + "': '" + value.getValue() + "'" + (value.isLocked() ? " [LOCKED]" : ""));
        }
    }

    public static void move14AndOlderFilesTo15StructureCatched() {
        try {
            DeploymentConfiguration.move14AndOlderFilesTo15Structure();
        }
        catch (Throwable t) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Critical error during converting old files to new. Continuing");
            OutputController.getLogger().log(t);
        }
    }

    private static void move14AndOlderFilesTo15Structure() {
        int errors = 0;
        String PRE_15_DEPLOYMENT_DIR = ".icedtea";
        String LEGACY_USER_HOME = System.getProperty("user.home") + File.separator + PRE_15_DEPLOYMENT_DIR;
        File configDir = new File(Defaults.USER_CONFIG_HOME);
        File cacheDir = new File(Defaults.USER_CACHE_HOME);
        File legacyUserDir = new File(LEGACY_USER_HOME);
        if (legacyUserDir.exists()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Legacy configuration and cache found. Those will be now transported to new locations");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Defaults.USER_CONFIG_HOME + " and " + Defaults.USER_CACHE_HOME);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "You should not see this message next time you run icedtea-web!");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Your custom dirs will not be touched and will work");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "-----------------------------------------------");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Preparing new directories:");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " " + Defaults.USER_CONFIG_HOME);
            errors += DeploymentConfiguration.resultToStd(configDir.mkdirs());
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " " + Defaults.USER_CACHE_HOME);
            errors += DeploymentConfiguration.resultToStd(cacheDir.mkdirs());
            String legacySecurity = LEGACY_USER_HOME + File.separator + "security";
            String currentSecurity = Defaults.USER_SECURITY;
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacySecurity, currentSecurity);
            String legacyCache = LEGACY_USER_HOME + File.separator + "cache";
            String currentCache = Defaults.getDefaults().get(KEY_USER_CACHE_DIR).getDefaultValue();
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyCache, currentCache);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Adapting recently_used to new destination");
            try {
                File f = new File(currentCache, "recently_used");
                String s = FileUtils.loadFileAsString(f);
                s = s.replace(legacyCache, currentCache);
                FileUtils.saveFile(s, f);
            }
            catch (IOException ex) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, ex);
                ++errors;
            }
            String legacyPcahceDir = LEGACY_USER_HOME + File.separator + "pcache";
            String currentPcacheDir = Defaults.getDefaults().get(KEY_USER_PERSISTENCE_CACHE_DIR).getDefaultValue();
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyPcahceDir, currentPcacheDir);
            String legacyLogDir = LEGACY_USER_HOME + File.separator + "log";
            String currentLogDir = Defaults.getDefaults().get(KEY_USER_LOG_DIR).getDefaultValue();
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyLogDir, currentLogDir);
            String legacyProperties = LEGACY_USER_HOME + File.separator + DEPLOYMENT_PROPERTIES;
            String currentProperties = Defaults.USER_CONFIG_HOME + File.separator + DEPLOYMENT_PROPERTIES;
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyProperties, currentProperties);
            String legacyPropertiesOld = LEGACY_USER_HOME + File.separator + DEPLOYMENT_PROPERTIES + ".old";
            String currentPropertiesOld = Defaults.USER_CONFIG_HOME + File.separator + DEPLOYMENT_PROPERTIES + ".old";
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyPropertiesOld, currentPropertiesOld);
            String legacyAppletTrust = LEGACY_USER_HOME + File.separator + APPLET_TRUST_SETTINGS;
            String currentAppletTrust = DeploymentConfiguration.getAppletTrustUserSettingsPath().getAbsolutePath();
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyAppletTrust, currentAppletTrust);
            String legacyTmp = LEGACY_USER_HOME + File.separator + "tmp";
            String currentTmp = Defaults.getDefaults().get(KEY_USER_TMP_DIR).getDefaultValue();
            errors += DeploymentConfiguration.moveLegacyToCurrent(legacyTmp, currentTmp);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Removing now empty " + LEGACY_USER_HOME);
            if ((errors += DeploymentConfiguration.resultToStd(legacyUserDir.delete())) != 0) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "There occureed " + errors + " errors");
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Please double check content of old data in " + LEGACY_USER_HOME + " with ");
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "new " + Defaults.USER_CONFIG_HOME + " and " + Defaults.USER_CACHE_HOME);
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "To disable this check again, please remove " + LEGACY_USER_HOME);
            }
        } else {
            OutputController.getLogger().log("System is already following XDG .cache and .config specifications");
            try {
                OutputController.getLogger().log("config: " + Defaults.USER_CONFIG_HOME + " file exists: " + configDir.exists());
            }
            catch (Exception ex) {
                OutputController.getLogger().log(ex);
            }
            try {
                OutputController.getLogger().log("cache: " + Defaults.USER_CACHE_HOME + " file exists:" + cacheDir.exists());
            }
            catch (Exception ex) {
                OutputController.getLogger().log(ex);
            }
        }
        DirectoryValidator.DirectoryCheckResults r = new DirectoryValidator().ensureDirs();
        if (!JNLPRuntime.isHeadless() && r.getFailures() > 0) {
            JOptionPane.showMessageDialog(null, r.getMessage());
        }
    }

    private static int moveLegacyToCurrent(String legacy, String current) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Moving " + legacy + " to " + current);
        File cf = new File(current);
        File old = new File(legacy);
        if (cf.exists()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Warning! Destination " + current + " exists!");
        }
        if (old.exists()) {
            boolean moved = old.renameTo(cf);
            return DeploymentConfiguration.resultToStd(moved);
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Source " + legacy + " do not exists, nothing to do");
        return 0;
    }

    private static int resultToStd(boolean securityMove) {
        if (securityMove) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "OK");
            return 0;
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "ERROR");
        return 1;
    }

    public static enum ConfigType {
        System,
        User;

    }
}

