## Correctness check of distributions in TMB

## Syntax table
syntax <- read.table("syntax_distributions.org",
                     sep="|",
                     header=TRUE,
                     stringsAsFactors=FALSE)[,2:3]

## Data and parameters required by syntax table
library(TMB)
data <- list(x=seq(-5,5,length=101),
             k=1:101,
             n=11:111,
             u=seq(0,1,length=101),
             p=(1:101)/sum(1:101)
             )
parameters <- list(p1=1,p2=2,prob=0.5)

## Make template
txt <- c(
    "// Autogenerated by check_distributions.R",
    "#include <TMB.hpp>",
    "template<class Type>",
    "Type objective_function<Type>::operator() ()",
    "{",
    paste0("  DATA_VECTOR(",names(data),");"),
    paste0("  PARAMETER(",names(parameters),");"),
    paste0("  REPORT(",gsub(" ","",syntax$TMB.syntax),");"),
    "  return 0;",
    "}"
    )
writeLines(txt,"autogenerated.cpp")
compile("autogenerated.cpp")

## Perform check
dyn.load(dynlib("autogenerated"))
obj <- MakeADFun(data=data,parameters=parameters,DLL="autogenerated")
result.TMB <- obj$report()
result.R <- lapply(syntax$R.syntax,function(x)eval(parse(text=x),c(data,parameters)))
names(result.R) <- gsub(" ","",syntax$TMB.syntax)
result.TMB <- result.TMB[names(result.R)]
compare <- function(R,TMB){
    i <- is.finite(R) & is.finite(TMB)
    list(
        max.dist = max(R[i]-TMB[i]),
        num.finite=sum(i),
        finite.ok = all(is.finite(TMB[is.finite(R)])),
        nan.ok = all(is.nan(TMB[is.nan(R)])),
        inf.ok = all(TMB[R==Inf]==Inf),
        neginf.ok = all(TMB[R==-Inf]==-Inf) )
}
ans <- Map(compare,result.R,result.TMB)
df <- data.frame(do.call("Map",c(list(f="c"),ans)))
df
