README
======
This folder contains TMB examples. If "examp.cpp" and "examp.R" both exists then "examp" is a valid example.
Test automation is provided by the files "Makefile" and "unittest.R". The purpose of the test is to
verify correctness of results and to verify that the timings are reasonable. Each example is associated with
a file "examp.expected.RData" with correct output from a reference test machine (For new examples this file is automatically generated, and correctness must be manually verified).
Perform a full test by running
* make clean
* make

A file "REPORT.md" (see below) will be generated with test results and timings. 
If the column "Max." is small (say <1e-6) the example is considered as passed in terms of correctness. 
If not, find out why by looking in "result details".
Column "timeindex" is the totaltime relative to the totaltime on the reference test machine. 
Thus "timeindex" should be fairly constant.

REPORT.md
=========

Example overview:
-----------------
    Examples in '.':
    
    "linreg_parallel": 
    "linreg":          
    "nmix":            
    "orange_big":      Scaled up version of the Orange Tree
                       example (50,000 latent random variables)
    "rw_sparse":       Identical with random walk example.
                       Utilizing sparse block structure so
                       efficient when the number of states is
                       high.
    "rw":              Random walk with multivariate correlated
                       increments and measurement noise.
    "socatt":          
    "spatial":         Spatial poisson GLMM on a grid, with
                       exponentially decaying correlation
                       function
    
    
Results and timings:
--------------------
                         Min.    Median      Max. totaltime timeindex
    linreg_parallel 0.000e+00 0.000e+00 0.000e+00     0.545 0.8307927
    linreg          0.000e+00 0.000e+00 0.000e+00     0.023 1.0454545
    nmix            0.000e+00 0.000e+00 0.000e+00     3.833 1.0472678
    orange_big      0.000e+00 0.000e+00 0.000e+00    51.905 0.9310815
    rw_sparse       1.282e-14 9.289e-14 4.547e-13     0.356 1.1021672
    rw              0.000e+00 0.000e+00 0.000e+00     0.310 0.9597523
    socatt          0.000e+00 0.000e+00 0.000e+00     2.321 1.0845794
    spatial         0.000e+00 0.000e+00 0.000e+00    19.125 0.9257915
    
Timing details:
---------------
                    MakeADFun nlminb  optim sdreport
    linreg              0.005  0.000  0.013    0.005
    linreg_parallel     0.277  0.000  0.268    0.000
    nmix                0.304  2.759  0.000    0.770
    orange_big          2.315 37.536  0.000   12.054
    rw                  0.005  0.000  0.217    0.088
    rw_sparse           0.009  0.000  0.233    0.114
    socatt              0.012  0.000  1.778    0.531
    spatial             0.135 17.549  0.000    1.441
    
Result details:
---------------
                                   optim.par               nlminb.par
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   1.282047e-14             0.000000e+00
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                                 optim.value              sdreport.sd
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   4.547474e-13             0.000000e+00
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                                sdreport.cov            optim.hessian
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   0.000000e+00             0.000000e+00
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                              sdreport.value         nlminb.objective
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   0.000000e+00             0.000000e+00
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                          sdreport.cov.fixed       sdreport.par.fixed
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   9.289444e-14             1.282047e-14
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                         sdreport.par.random  sdreport.gradient.fixed
    linreg                      0.000000e+00             0.000000e+00
    linreg_parallel             0.000000e+00             0.000000e+00
    nmix                        0.000000e+00             0.000000e+00
    orange_big                  0.000000e+00             0.000000e+00
    rw                          0.000000e+00             0.000000e+00
    rw_sparse                   2.842171e-14             2.748160e-13
    socatt                      0.000000e+00             0.000000e+00
    spatial                     0.000000e+00             0.000000e+00
                    sdreport.diag.cov.random
    linreg                      0.000000e+00
    linreg_parallel             0.000000e+00
    nmix                        0.000000e+00
    orange_big                  0.000000e+00
    rw                          0.000000e+00
    rw_sparse                   1.993961e-13
    socatt                      0.000000e+00
    spatial                     0.000000e+00

Profiling:
----------
Examples can be profiled using intel vtune. To profile e.g. example "spatial" run
* make spatial.profile
This requires "amplxe-cl" on your path. Then view the profile with
* amplxe-gui spatial.profile/spatial.profile.amplxe
