/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;
import net.sourceforge.jnlp.security.appletextendedsecurity.InvalidLineException;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.lockingfile.LockingReaderWriter;
import net.sourceforge.jnlp.util.lockingfile.StorageIoException;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UnsignedAppletActionStorageImpl
extends LockingReaderWriter
implements UnsignedAppletActionStorage {
    protected List<UnsignedAppletActionEntry> items;
    private String readVersion = null;
    public static final String versionPreffix = "#VERSION ";
    public static final String BACKUP_SUFFIX = "-backup";
    public static final int currentVersion = 2;
    private int lineCounter = 0;
    private boolean loadingDisabled = false;

    public UnsignedAppletActionStorageImpl(File location) {
        super(location);
    }

    @Override
    public void writeContents() throws IOException {
        super.writeContents();
    }

    @Override
    public synchronized void writeContentsLocked() throws IOException {
        super.writeContentsLocked();
    }

    @Override
    protected void readContents() throws IOException {
        if (this.items == null) {
            this.items = new ArrayList<UnsignedAppletActionEntry>();
        } else {
            this.items.clear();
        }
        super.readContents();
    }

    @Override
    protected void readLine(String line) {
        if (line.trim().length() != 0) {
            ++this.lineCounter;
            if (line.startsWith(versionPreffix) && line.trim().split("\\s+").length > 1) {
                if (this.readVersion == null) {
                    this.readVersion = line.trim();
                    this.actOnVersionLoad();
                }
            } else {
                if (this.lineCounter > 0 && this.readVersion == null) {
                    this.actOnNoVersionLoad();
                }
                if (!this.loadingDisabled) {
                    this.items.add(UnsignedAppletActionEntry.createFromString(line));
                }
            }
        }
    }

    @Override
    public void writeContent(BufferedWriter bw) throws IOException {
        this.lineCounter = 0;
        this.readVersion = null;
        bw.write("#VERSION 2 - note, do not edit or modify this line. It may cause removal of this file.");
        bw.newLine();
        for (UnsignedAppletActionEntry item : this.items) {
            try {
                item.write(bw);
                bw.newLine();
            }
            catch (InvalidLineException ex) {
                OutputController.getLogger().log(ex);
            }
        }
    }

    @Override
    public void add(final UnsignedAppletActionEntry item) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    UnsignedAppletActionStorageImpl.this.readContents();
                    UnsignedAppletActionStorageImpl.this.items.add(item);
                    UnsignedAppletActionStorageImpl.this.writeContents();
                }
                catch (IOException ex) {
                    throw new StorageIoException(ex);
                }
            }
        });
    }

    @Override
    public void update(final UnsignedAppletActionEntry item) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    if (UnsignedAppletActionStorageImpl.this.items == null) {
                        throw new StorageIoException("Storage is not initialised, can not update");
                    }
                    if (!UnsignedAppletActionStorageImpl.this.items.contains(item)) {
                        throw new StorageIoException("Storage does not contain item you are updating. can not update");
                    }
                    UnsignedAppletActionStorageImpl.this.writeContents();
                }
                catch (IOException ex) {
                    throw new StorageIoException(ex);
                }
            }
        });
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItem(String documentBase, String codeBase, List<String> archives) {
        List<UnsignedAppletActionEntry> results = this.getMatchingItems(documentBase, codeBase, archives);
        if (results == null || results.isEmpty()) {
            return null;
        }
        for (UnsignedAppletActionEntry candidate : results) {
            if (candidate.getUnsignedAppletAction() != ExecuteAppletAction.ALWAYS && candidate.getUnsignedAppletAction() != ExecuteAppletAction.NEVER) continue;
            return candidate;
        }
        return results.get(0);
    }

    public List<UnsignedAppletActionEntry> getMatchingItems(String documentBase, String codeBase, List<String> archives) {
        ArrayList<UnsignedAppletActionEntry> result = new ArrayList<UnsignedAppletActionEntry>();
        this.lock();
        try {
            this.readContents();
            if (this.items == null) {
                ArrayList<UnsignedAppletActionEntry> arrayList = result;
                return arrayList;
            }
            for (UnsignedAppletActionEntry unsignedAppletActionEntry : this.items) {
                if (!this.isMatching(unsignedAppletActionEntry, documentBase, codeBase, archives)) continue;
                result.add(unsignedAppletActionEntry);
            }
        }
        catch (IOException e) {
            throw new StorageIoException(e);
        }
        finally {
            this.unlock();
        }
        return result;
    }

    private boolean isMatching(UnsignedAppletActionEntry unsignedAppletActionEntry, String documentBase, String codeBase, List<String> archives) {
        try {
            boolean result = true;
            if (documentBase != null && !documentBase.trim().isEmpty()) {
                boolean bl = result = result && documentBase.matches(unsignedAppletActionEntry.getDocumentBase().getRegEx());
            }
            if (codeBase != null && !codeBase.trim().isEmpty()) {
                boolean bl = result = result && codeBase.matches(unsignedAppletActionEntry.getCodeBase().getRegEx());
            }
            if (archives != null) {
                List<String> saved = unsignedAppletActionEntry.getArchives();
                if (saved == null || saved.isEmpty()) {
                    return result;
                }
                result = result && this.compareArchives(archives, saved);
            }
            return result;
        }
        catch (PatternSyntaxException ex) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, ex);
            return false;
        }
    }

    public String toString() {
        return this.getBackingFile() + " " + super.toString();
    }

    private boolean compareArchives(List<String> archives, List<String> saved) {
        if (archives == null && saved != null) {
            return false;
        }
        if (archives != null && saved == null) {
            return false;
        }
        if (archives == null && saved == null) {
            return true;
        }
        if (archives.size() != saved.size()) {
            return false;
        }
        Collections.sort(archives);
        Collections.sort(saved);
        for (int i = 0; i < saved.size(); ++i) {
            String string2;
            String string1 = saved.get(i);
            if (string1 == (string2 = archives.get(i))) continue;
            if (string1 == null || string2 == null) {
                return false;
            }
            if (string1.trim().equals(string2.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByDocumentBase(String documentBase) {
        return this.getMatchingItem(documentBase, null, null);
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByCodeBase(String codeBase) {
        return this.getMatchingItem(null, codeBase, null);
    }

    @Override
    public UnsignedAppletActionEntry getMatchingItemByBases(String documentBase, String codeBase) {
        return this.getMatchingItem(documentBase, codeBase, null);
    }

    private void actOnVersionLoad() {
        String versionS = this.readVersion.split("\\s+")[1];
        int version = 0;
        try {
            version = Integer.valueOf(versionS);
        }
        catch (NumberFormatException e) {
            OutputController.getLogger().log(e);
        }
        if (version < 2) {
            OutputController.getLogger().log("Stoping laoding of vulnereable " + this.getBackingFile().getAbsolutePath() + ". Will be replaced");
            this.loadingDisabled = true;
            this.backupOldFile(version, this.getBackingFile());
        } else {
            this.loadingDisabled = false;
        }
    }

    private void actOnNoVersionLoad() {
        this.readVersion = "#VERSION 0";
        this.actOnVersionLoad();
    }

    private void backupOldFile(int version, File backingFile) {
        try {
            File backup = new File(backingFile.getAbsolutePath() + "." + version + BACKUP_SUFFIX);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "backuping " + this.getBackingFile().getAbsolutePath() + " as " + backup.getName());
            String warning = "- !WARNING! this is automated copy of old " + backingFile.getName() + " which was removed/replaced. Before you blindly copy those items back, please note, that this file might be modified without your approval by evil attacker. It is advised to not return below lines, or verify them before returning";
            String s = FileUtils.loadFileAsString(backingFile);
            s.replaceFirst("\\s*", "");
            s = s.startsWith(versionPreffix) ? s.replaceFirst("\n", " " + warning + "\n") : this.readVersion + " " + warning + "\n" + s;
            FileUtils.saveFile(s, backup);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Error during backuping: " + ex.getMessage());
            OutputController.getLogger().log(ex);
        }
    }
}

