/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPMatcher;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.NullJnlpFileException;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.IllegalResourceDescriptorException;
import net.sourceforge.jnlp.cache.NativeLibraryStorage;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.CachedJarFileCallback;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.LocateJnlpClassLoader;
import net.sourceforge.jnlp.runtime.ManageJnlpResources;
import net.sourceforge.jnlp.runtime.ManifestAttributesChecker;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.JNLPAppVerifier;
import net.sourceforge.jnlp.security.PluginAppVerifier;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.tools.JarCertVerifier;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.misc.JarIndex;

public class JNLPClassLoader
extends URLClassLoader {
    public static final String TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";
    public static final String APPLICATION = "JNLP-INF/APPLICATION.JNLP";
    private boolean isSignedJNLP = false;
    private static Map<String, JNLPClassLoader> uniqueKeyToLoader = new ConcurrentHashMap<String, JNLPClassLoader>();
    private static Map<String, ReentrantLock> uniqueKeyToLock = new HashMap<String, ReentrantLock>();
    private NativeLibraryStorage nativeLibraryStorage;
    private AccessControlContext acc = AccessController.getContext();
    private List<Permission> resourcePermissions;
    private ApplicationInstance app = null;
    private JNLPClassLoader[] loaders = null;
    private boolean strict = true;
    private ResourceTracker tracker = new ResourceTracker(true);
    private UpdatePolicy updatePolicy;
    private JNLPFile file;
    private ResourcesDesc resources;
    private SecurityDesc security;
    private ArrayList<Permission> runtimePermissions = new ArrayList();
    private List<JARDesc> available = Collections.synchronizedList(new ArrayList());
    private final JarCertVerifier jcv;
    private SigningState signing = SigningState.NONE;
    private List<JarIndex> jarIndexes = Collections.synchronizedList(new ArrayList());
    private Set<String> classpaths = Collections.synchronizedSet(new HashSet());
    private Set<String> jarEntries = Collections.synchronizedSet(new TreeSet());
    private Map<URL, SecurityDesc> jarLocationSecurityMap = Collections.synchronizedMap(new HashMap());
    private Set<URL> alreadyTried = Collections.synchronizedSet(new HashSet());
    private CodeBaseClassLoader codeBaseLoader;
    private boolean foundMainJar = false;
    private String mainClass = null;
    private int useCount = 0;
    private boolean enableCodeBase = false;
    private final SecurityDelegate securityDelegate;

    protected JNLPClassLoader(JNLPFile file, UpdatePolicy policy) throws LaunchException {
        this(file, policy, null, false);
    }

    protected JNLPClassLoader(JNLPFile file, UpdatePolicy policy, String mainName, boolean enableCodeBase) throws LaunchException {
        super(new URL[0], JNLPClassLoader.class.getClassLoader());
        OutputController.getLogger().log("New classloader: " + file.getFileLocation());
        this.file = file;
        this.updatePolicy = policy;
        this.resources = file.getResources();
        this.nativeLibraryStorage = new NativeLibraryStorage(this.tracker);
        this.mainClass = mainName;
        this.enableCodeBase = enableCodeBase;
        AppVerifier verifier = file instanceof PluginBridge && !((PluginBridge)file).useJNLPHref() ? new PluginAppVerifier() : new JNLPAppVerifier();
        this.jcv = new JarCertVerifier(verifier);
        if (this.enableCodeBase) {
            this.addToCodeBaseLoader(this.file.getCodeBase());
        }
        this.securityDelegate = new SecurityDelegateImpl(this);
        this.initializeExtensions();
        this.initializeResources();
        file.getManifestsAttributes().setLoader(this);
        this.initializePermissions();
        this.setSecurity();
        ManifestAttributesChecker mac = new ManifestAttributesChecker(this.security, file, this.signing, this.securityDelegate);
        mac.checkAll();
        this.installShutdownHooks();
    }

    private void installShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JNLPClassLoader.this.nativeLibraryStorage.cleanupTemporaryFolder();
            }
        });
    }

    private void setSecurity() throws LaunchException {
        URL codebase = UrlUtils.guessCodeBase(this.file);
        this.security = this.securityDelegate.getClassLoaderSecurity(codebase.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReentrantLock getUniqueKeyLock(String uniqueKey) {
        Map<String, ReentrantLock> map = uniqueKeyToLock;
        synchronized (map) {
            ReentrantLock storedLock = uniqueKeyToLock.get(uniqueKey);
            if (storedLock == null) {
                storedLock = new ReentrantLock();
                uniqueKeyToLock.put(uniqueKey, storedLock);
            }
            return storedLock;
        }
    }

    private static JNLPClassLoader createInstance(JNLPFile file, UpdatePolicy policy, String mainName, boolean enableCodeBase) throws LaunchException {
        String uniqueKey = file.getUniqueKey();
        JNLPClassLoader baseLoader = uniqueKeyToLoader.get(uniqueKey);
        JNLPClassLoader loader = new JNLPClassLoader(file, policy, mainName, enableCodeBase);
        if (loader.getSigningState() == SigningState.PARTIAL) {
            loader.securityDelegate.promptUserOnPartialSigning();
        } else if (!loader.getSigning() && !loader.securityDelegate.userPromptedForSandbox() && file instanceof PluginBridge) {
            UnsignedAppletTrustConfirmation.checkUnsignedWithUserIfRequired((PluginBridge)file);
        }
        JNLPClassLoader extLoader = uniqueKeyToLoader.get(uniqueKey);
        if (extLoader != null && extLoader != loader) {
            if (loader.getSigning() != extLoader.getSigning()) {
                loader.securityDelegate.promptUserOnPartialSigning();
            }
            loader.merge(extLoader);
            extLoader.decrementLoaderUseCount();
        }
        if (baseLoader != null && baseLoader != loader) {
            loader.merge(baseLoader);
        }
        return loader;
    }

    public static JNLPClassLoader getInstance(JNLPFile file, UpdatePolicy policy, boolean enableCodeBase) throws LaunchException {
        return JNLPClassLoader.getInstance(file, policy, null, enableCodeBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNLPClassLoader getInstance(JNLPFile file, UpdatePolicy policy, String mainName, boolean enableCodeBase) throws LaunchException {
        JNLPClassLoader baseLoader = null;
        JNLPClassLoader loader = null;
        String uniqueKey = file.getUniqueKey();
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(uniqueKey);
        synchronized (reentrantLock) {
            baseLoader = uniqueKeyToLoader.get(uniqueKey);
            if (baseLoader == null || file.isApplication() && !baseLoader.getJNLPFile().getFileLocation().equals(file.getFileLocation())) {
                loader = JNLPClassLoader.createInstance(file, policy, mainName, enableCodeBase);
            } else {
                if (!file.isApplication()) {
                    loader = new JNLPClassLoader(file, policy, mainName, enableCodeBase);
                    if (baseLoader != null) {
                        baseLoader.merge(loader);
                    }
                }
                loader = baseLoader;
            }
            loader.incrementLoaderUseCount();
            uniqueKeyToLoader.put(uniqueKey, loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNLPClassLoader getInstance(URL location, String uniqueKey, Version version, ParserSettings settings, UpdatePolicy policy, String mainName, boolean enableCodeBase) throws IOException, ParseException, LaunchException {
        JNLPClassLoader loader;
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(uniqueKey);
        synchronized (reentrantLock) {
            loader = uniqueKeyToLoader.get(uniqueKey);
            if (loader == null || !location.equals(loader.getJNLPFile().getFileLocation())) {
                JNLPFile jnlpFile = new JNLPFile(location, uniqueKey, version, settings, policy);
                loader = JNLPClassLoader.getInstance(jnlpFile, policy, mainName, enableCodeBase);
            }
        }
        return loader;
    }

    void initializeExtensions() {
        ExtensionDesc[] extDescs = this.resources.getExtensions();
        ArrayList<JNLPClassLoader> loaderList = new ArrayList<JNLPClassLoader>();
        loaderList.add(this);
        if (this.mainClass == null) {
            LaunchDesc ad;
            LaunchDesc obj = this.file.getLaunchInfo();
            if (obj instanceof ApplicationDesc) {
                ad = (ApplicationDesc)this.file.getLaunchInfo();
                this.mainClass = ((ApplicationDesc)ad).getMainClass();
            } else if (obj instanceof AppletDesc) {
                ad = (AppletDesc)this.file.getLaunchInfo();
                this.mainClass = ((AppletDesc)ad).getMainClass();
            }
        }
        for (ExtensionDesc ext : extDescs) {
            try {
                String uniqueKey = this.getJNLPFile().getUniqueKey();
                JNLPClassLoader loader = JNLPClassLoader.getInstance(ext.getLocation(), uniqueKey, ext.getVersion(), this.file.getParserSettings(), this.updatePolicy, this.mainClass, this.enableCodeBase);
                loaderList.add(loader);
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
        }
        this.loaders = loaderList.toArray(new JNLPClassLoader[loaderList.size()]);
    }

    void initializePermissions() {
        JARDesc[] jars;
        this.resourcePermissions = new ArrayList<Permission>();
        for (JARDesc jar : jars = this.resources.getJARs()) {
            Permission p = CacheUtil.getReadPermission(jar.getLocation(), jar.getVersion());
            if (p == null) {
                OutputController.getLogger().log("Unable to add permission for " + jar.getLocation());
            } else {
                OutputController.getLogger().log("Permission added: " + p.toString());
            }
            if (p == null) continue;
            this.resourcePermissions.add(p);
        }
    }

    boolean isInvalidJar(JARDesc jar) {
        File cacheFile = this.tracker.getCacheFile(jar.getLocation());
        if (cacheFile == null) {
            return false;
        }
        boolean isInvalid = false;
        try {
            net.sourceforge.jnlp.util.JarFile jarFile = new net.sourceforge.jnlp.util.JarFile(cacheFile.getAbsolutePath());
            jarFile.close();
        }
        catch (IOException ioe) {
            isInvalid = true;
        }
        return isInvalid;
    }

    private boolean shouldFilterInvalidJars() {
        if (this.file instanceof PluginBridge) {
            PluginBridge pluginBridge = (PluginBridge)this.file;
            return !pluginBridge.useJNLPHref();
        }
        return false;
    }

    void initializeResources() throws LaunchException {
        JARDesc[] jars;
        if (this.file instanceof PluginBridge) {
            PluginBridge bridge = (PluginBridge)this.file;
            for (String codeBaseFolder : bridge.getCodeBaseFolders()) {
                try {
                    this.addToCodeBaseLoader(new URL(this.file.getCodeBase(), codeBaseFolder));
                }
                catch (MalformedURLException mfe) {
                    OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Problem trying to add folder to code base:");
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, mfe);
                }
            }
        }
        if ((jars = this.resources.getJARs()).length == 0) {
            boolean allSigned = this.loaders.length > 1;
            for (int i = 1; i < this.loaders.length; ++i) {
                if (this.loaders[i].getSigning()) continue;
                allSigned = false;
                break;
            }
            if (allSigned) {
                this.signing = SigningState.FULL;
            }
            this.foundMainJar = this.foundMainJar || this.hasMainInExtensions();
            return;
        }
        ArrayList<JARDesc> initialJars = new ArrayList<JARDesc>();
        for (JARDesc jar : jars) {
            this.available.add(jar);
            if (jar.isEager()) {
                initialJars.add(jar);
            }
            this.tracker.addResource(jar.getLocation(), jar.getVersion(), this.file.getDownloadOptions(), jar.isCacheable() ? JNLPRuntime.getDefaultUpdatePolicy() : UpdatePolicy.FORCE);
        }
        if (initialJars.size() == 0) {
            initialJars.add(jars[0]);
        }
        if (this.strict) {
            this.fillInPartJars(initialJars);
        }
        this.waitForJars(initialJars);
        if (this.shouldFilterInvalidJars()) {
            Iterator iterator = initialJars.iterator();
            while (iterator.hasNext()) {
                JARDesc jar = (JARDesc)iterator.next();
                if (!this.isInvalidJar(jar)) continue;
                iterator.remove();
                this.tracker.removeResource(jar.getLocation());
                this.available.remove(jar);
            }
        }
        if (JNLPRuntime.isVerifying()) {
            try {
                this.jcv.add(initialJars, this.tracker);
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LFatalVerification"), Translator.R("LFatalVerificationInfo") + ": " + e.getMessage());
            }
            if (this.jcv.isFullySigned()) {
                boolean externalAppletMainClass;
                this.signing = SigningState.FULL;
                this.checkForMain(initialJars);
                while (!this.foundMainJar && this.available != null && this.available.size() != 0) {
                    this.addNextResource();
                }
                this.foundMainJar = this.foundMainJar || this.hasMainInExtensions();
                boolean bl = externalAppletMainClass = this.file.getLaunchInfo() != null && !this.foundMainJar && (this.available == null || this.available.size() == 0);
                if (externalAppletMainClass) {
                    if (this.codeBaseLoader != null) {
                        try {
                            this.codeBaseLoader.findClass(this.mainClass);
                        }
                        catch (ClassNotFoundException extCnfe) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, extCnfe);
                            throw new LaunchException(this.file, extCnfe, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo"));
                        }
                    } else {
                        throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo"));
                    }
                }
                if (!this.jcv.allJarsSigned()) {
                    this.checkPartialSigningWithUser();
                }
                if (!this.isSignedJNLP && this.foundMainJar) {
                    this.file.setSignedJNLPAsMissing();
                }
                if (!this.jcv.isTriviallySigned()) {
                    this.checkTrustWithUser();
                }
            } else {
                this.signing = SigningState.NONE;
            }
        }
        boolean containsSignedJar = false;
        boolean containsUnsignedJar = false;
        for (JARDesc jarDesc : this.file.getResources().getJARs()) {
            File cachedFile;
            try {
                cachedFile = this.tracker.getCacheFile(jarDesc.getLocation());
            }
            catch (IllegalResourceDescriptorException irde) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jarDesc.getLocation() + " is not a valid jar file. Continuing.");
                continue;
            }
            if (cachedFile == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jarDesc.getLocation() + " not found. Continuing.");
                continue;
            }
            URL codebase = this.file.getCodeBase() != null ? this.file.getCodeBase() : this.file.getResources().getMainJAR().getLocation();
            SecurityDesc jarSecurity = this.securityDelegate.getCodebaseSecurityDesc(jarDesc, codebase.getHost());
            if (jarSecurity.getSecurityType().equals(SecurityDesc.SANDBOX_PERMISSIONS)) {
                containsUnsignedJar = true;
            } else {
                containsSignedJar = true;
            }
            this.jarLocationSecurityMap.put(jarDesc.getLocation(), jarSecurity);
        }
        if (containsSignedJar && containsUnsignedJar) {
            this.checkPartialSigningWithUser();
        }
        this.activateJars(initialJars);
    }

    public String checkForAttributeInJars(List<JARDesc> jars, Attributes.Name name) {
        if (jars.isEmpty()) {
            return null;
        }
        String result = null;
        JARDesc mainJarDesc = ResourcesDesc.getMainJAR(jars);
        result = this.getManifestAttribute(mainJarDesc.getLocation(), name);
        if (result != null) {
            return result;
        }
        JARDesc firstJarDesc = jars.get(0);
        result = this.getManifestAttribute(firstJarDesc.getLocation(), name);
        if (result != null) {
            return result;
        }
        for (JARDesc jarDesc : jars) {
            String attributeInThisJar = this.getManifestAttribute(jarDesc.getLocation(), name);
            if (attributeInThisJar == null) continue;
            if (result == null) {
                result = attributeInThisJar;
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    void checkForMain(List<JARDesc> jars) throws LaunchException {
        LaunchDesc launchDesc;
        if (this.mainClass == null && (launchDesc = this.file.getLaunchInfo()) != null) {
            this.mainClass = launchDesc.getMainClass();
        }
        if (this.mainClass == null) {
            this.mainClass = this.checkForAttributeInJars(jars, Attributes.Name.MAIN_CLASS);
        }
        String desiredJarEntryName = this.mainClass + ".class";
        for (JARDesc jar : jars) {
            try {
                File localFile = this.tracker.getCacheFile(jar.getLocation());
                if (localFile == null) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "JAR " + jar.getLocation() + " not found. Continuing.");
                    continue;
                }
                net.sourceforge.jnlp.util.JarFile jarFile = new net.sourceforge.jnlp.util.JarFile(localFile);
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String jeName = entry.getName().replaceAll("/", ".");
                    if (!jeName.equals(desiredJarEntryName)) continue;
                    this.foundMainJar = true;
                    this.verifySignedJNLP(jar, jarFile);
                    break;
                }
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    String getMainClassName(URL location) {
        return this.getManifestAttribute(location, Attributes.Name.MAIN_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManifestAttribute(URL location, Attributes.Name attribute) {
        String attributeValue = null;
        File f = this.tracker.getCacheFile(location);
        if (f != null) {
            Manifest manifest;
            net.sourceforge.jnlp.util.JarFile mainJar;
            block6: {
                mainJar = null;
                mainJar = new net.sourceforge.jnlp.util.JarFile(f);
                manifest = mainJar.getManifest();
                if (manifest != null && manifest.getMainAttributes() != null) break block6;
                String string = null;
                StreamUtils.closeSilently(mainJar);
                return string;
            }
            try {
                attributeValue = manifest.getMainAttributes().getValue(attribute);
            }
            catch (IOException ioe) {
                try {
                    attributeValue = null;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeSilently(mainJar);
                    throw throwable;
                }
                StreamUtils.closeSilently(mainJar);
            }
            StreamUtils.closeSilently(mainJar);
        }
        return attributeValue;
    }

    public boolean hasMainJar() {
        return this.foundMainJar;
    }

    private boolean hasMainInExtensions() {
        boolean foundMain = false;
        for (int i = 1; i < this.loaders.length && !foundMain; ++i) {
            foundMain = this.loaders[i].hasMainJar();
        }
        return foundMain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySignedJNLP(JARDesc jarDesc, net.sourceforge.jnlp.util.JarFile jarFile) throws LaunchException {
        block10: {
            ArrayList<JARDesc> desc = new ArrayList<JARDesc>();
            desc.add(jarDesc);
            InputStream inStream = null;
            InputStreamReader inputReader = null;
            FileReader fr = null;
            FileReader jnlpReader = null;
            try {
                if (!this.jcv.isFullySigned()) break block10;
                for (JarEntry je : Collections.list(jarFile.entries())) {
                    JNLPMatcher matcher;
                    String jeName = je.getName().toUpperCase();
                    if (!jeName.equals(TEMPLATE) && !jeName.equals(APPLICATION)) continue;
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Creating Jar InputStream from JarEntry");
                    inStream = jarFile.getInputStream(je);
                    inputReader = new InputStreamReader(inStream);
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Creating File InputStream from lauching JNLP file");
                    JNLPFile jnlp = this.getJNLPFile();
                    URL url = jnlp.getFileLocation();
                    File jn = null;
                    jn = url.getProtocol().toLowerCase().equals("file") ? new File(url.getPath()) : CacheUtil.getCacheFile(url, null);
                    jnlpReader = fr = new FileReader(jn);
                    if (jeName.equals(APPLICATION)) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "APPLICATION.JNLP has been located within signed JAR. Starting verfication...");
                        matcher = new JNLPMatcher(inputReader, jnlpReader, false);
                    } else {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "APPLICATION_TEMPLATE.JNLP has been located within signed JAR. Starting verfication...");
                        matcher = new JNLPMatcher(inputReader, jnlpReader, true);
                    }
                    if (!matcher.isMatch()) {
                        throw new JNLPMatcherException("Signed Application did not match launching JNLP File");
                    }
                    this.isSignedJNLP = true;
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Signed Application Verification Successful");
                    break;
                }
            }
            catch (JNLPMatcherException e) {
                throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedJNLPFileDidNotMatch"), Translator.R(e.getMessage()));
            }
            catch (Exception e) {
                OutputController.getLogger().log(e);
            }
            finally {
                StreamUtils.closeSilently(inStream);
                StreamUtils.closeSilently(inputReader);
                StreamUtils.closeSilently(fr);
                StreamUtils.closeSilently(jnlpReader);
            }
        }
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Ending check for signed JNLP file...");
    }

    private void checkTrustWithUser() throws LaunchException {
        if (JNLPRuntime.isTrustNone()) {
            if (!this.securityDelegate.getRunInSandbox()) {
                this.setRunInSandbox();
            }
            return;
        }
        if (JNLPRuntime.isTrustAll() || this.securityDelegate.getRunInSandbox()) {
            return;
        }
        if (this.getSigningState() == SigningState.FULL && this.jcv.isFullySigned() && !this.jcv.getAlreadyTrustPublisher()) {
            this.jcv.checkTrustWithUser(this.securityDelegate, this.file);
        }
    }

    public void setRunInSandbox() throws LaunchException {
        this.securityDelegate.setRunInSandbox();
    }

    public boolean userPromptedForSandbox() {
        return this.securityDelegate.getRunInSandbox();
    }

    public void enableCodeBase() {
        this.addToCodeBaseLoader(this.file.getCodeBase());
    }

    public void setApplication(ApplicationInstance app) {
        if (this.app != null) {
            OutputController.getLogger().log(new IllegalStateException("Application can only be set once"));
            return;
        }
        this.app = app;
    }

    public ApplicationInstance getApplication() {
        return this.app;
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        try {
            Permissions result = new Permissions();
            if (this.security != null) {
                PermissionCollection permissions = this.security.getSandBoxPermissions();
                if (cs == null) {
                    throw new NullPointerException("Code source was null");
                }
                if (cs.getCodeSigners() != null) {
                    Object securityType;
                    if (cs.getLocation() == null) {
                        throw new NullPointerException("Code source location was null");
                    }
                    if (this.getCodeSourceSecurity(cs.getLocation()) == null) {
                        throw new NullPointerException("Code source security was null");
                    }
                    if (this.getCodeSourceSecurity(cs.getLocation()).getSecurityType() == null) {
                        OutputController.getLogger().log(new NullPointerException("Warning! Code source security type was null"));
                    }
                    if (SecurityDesc.ALL_PERMISSIONS.equals(securityType = this.getCodeSourceSecurity(cs.getLocation()).getSecurityType()) || SecurityDesc.J2EE_PERMISSIONS.equals(securityType)) {
                        permissions = this.getCodeSourceSecurity(cs.getLocation()).getPermissions(cs);
                    }
                }
                for (Permission perm : Collections.list(permissions.elements())) {
                    result.add(perm);
                }
            }
            for (Permission perm : this.resourcePermissions) {
                result.add(perm);
            }
            for (Permission perm : this.runtimePermissions) {
                result.add(perm);
            }
            if (cs.getLocation() != null && cs.getLocation().getHost().length() > 0) {
                result.add(new SocketPermission(cs.getLocation().getHost(), "connect, accept"));
            }
            return result;
        }
        catch (RuntimeException ex) {
            OutputController.getLogger().log(ex);
            throw ex;
        }
    }

    protected void addPermission(Permission p) {
        this.runtimePermissions.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInPartJars(List<JARDesc> jars) {
        for (int x = 0; x < jars.size(); ++x) {
            String part = jars.get(x).getPart();
            List<JARDesc> list = this.available;
            synchronized (list) {
                for (JARDesc jar : this.available) {
                    if (part == null || !part.equals(jar.getPart()) || jars.contains(jar)) continue;
                    jars.add(jar);
                }
                continue;
            }
        }
    }

    protected void activateJars(final List<JARDesc> jars) {
        PrivilegedAction<Void> activate = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JNLPClassLoader.this.waitForJars(jars);
                for (JARDesc jar : jars) {
                    JNLPClassLoader.this.available.remove(jar);
                    File localFile = JNLPClassLoader.this.tracker.getCacheFile(jar.getLocation());
                    try {
                        net.sourceforge.jnlp.util.JarFile jarFile;
                        URL location = jar.getLocation();
                        if (localFile != null) {
                            location = localFile.toURL();
                            jarFile = new net.sourceforge.jnlp.util.JarFile(localFile);
                            for (JarEntry je : Collections.list(jarFile.entries())) {
                                if (je.getName().endsWith(".jar")) {
                                    int read;
                                    String extractedJarLocation = localFile.getParent() + "/" + je.getName();
                                    File parentDir = new File(extractedJarLocation).getParentFile();
                                    if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                                        throw new RuntimeException(Translator.R("RNestedJarExtration"));
                                    }
                                    FileOutputStream extractedJar = new FileOutputStream(extractedJarLocation);
                                    InputStream is = jarFile.getInputStream(je);
                                    byte[] bytes = new byte[1024];
                                    int fileSize = read = is.read(bytes);
                                    while (read > 0) {
                                        extractedJar.write(bytes, 0, read);
                                        read = is.read(bytes);
                                        fileSize += read;
                                    }
                                    is.close();
                                    extractedJar.close();
                                    if (fileSize <= 0) continue;
                                    JNLPClassLoader.this.tracker.addResource(new File(extractedJarLocation).toURL(), null, null, null);
                                    URL codebase = JNLPClassLoader.this.file.getCodeBase();
                                    if (codebase == null) {
                                        codebase = JNLPClassLoader.this.file.getResources().getMainJAR().getLocation();
                                    }
                                    SecurityDesc jarSecurity = JNLPClassLoader.this.securityDelegate.getJarPermissions(codebase.getHost());
                                    try {
                                        URL fileURL = new URL("file://" + extractedJarLocation);
                                        URL fakeRemote = new URL(jar.getLocation().toString() + "!" + je.getName());
                                        CachedJarFileCallback.getInstance().addMapping(fakeRemote, fileURL);
                                        JNLPClassLoader.this.addURL(fakeRemote);
                                        JNLPClassLoader.this.jarLocationSecurityMap.put(fakeRemote, jarSecurity);
                                    }
                                    catch (MalformedURLException mfue) {
                                        OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Unable to add extracted nested jar to classpath");
                                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, mfue);
                                    }
                                }
                                JNLPClassLoader.this.jarEntries.add(je.getName());
                            }
                            jarFile.close();
                        }
                        JNLPClassLoader.this.addURL(jar.getLocation());
                        if (localFile != null) {
                            JarIndex index;
                            CachedJarFileCallback.getInstance().addMapping(jar.getLocation(), localFile.toURL());
                            jarFile = new net.sourceforge.jnlp.util.JarFile(localFile.getAbsolutePath());
                            Manifest mf = jarFile.getManifest();
                            if (JNLPClassLoader.this.file instanceof PluginBridge && !((PluginBridge)JNLPClassLoader.this.file).useJNLPHref()) {
                                JNLPClassLoader.this.classpaths.addAll(JNLPClassLoader.this.getClassPathsFromManifest(mf, jar.getLocation().getPath()));
                            }
                            if ((index = JarIndex.getJarIndex((JarFile)jarFile, null)) != null) {
                                JNLPClassLoader.this.jarIndexes.add(index);
                            }
                            jarFile.close();
                        } else {
                            CachedJarFileCallback.getInstance().addMapping(jar.getLocation(), jar.getLocation());
                        }
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Activate jar: " + location);
                    }
                    catch (Exception ex) {
                        OutputController.getLogger().log(ex);
                    }
                    JNLPClassLoader.this.nativeLibraryStorage.addSearchJar(jar.getLocation());
                }
                return null;
            }
        };
        AccessController.doPrivileged(activate, this.acc);
    }

    @Override
    protected String findLibrary(String lib) {
        String syslib = System.mapLibraryName(lib);
        File libFile = this.nativeLibraryStorage.findLibrary(syslib);
        if (libFile != null) {
            return libFile.toString();
        }
        String result = super.findLibrary(lib);
        if (result != null) {
            return result;
        }
        return this.findLibraryExt(lib);
    }

    protected String findLibraryExt(String lib) {
        for (JNLPClassLoader loader : this.loaders) {
            String result = null;
            if (loader != this) {
                result = loader.findLibrary(lib);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void waitForJars(List<JARDesc> jars) {
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            JARDesc jar = jars.get(i);
            urls[i] = jar.getLocation();
        }
        CacheUtil.waitForResources(this.app, this.tracker, urls, this.file.getTitle());
    }

    protected Class<?> findLoadedClassAll(String name) {
        for (JNLPClassLoader loader : this.loaders) {
            Class<?> result = null;
            result = loader == this ? JNLPClassLoader.super.findLoadedClass(name) : loader.findLoadedClassAll(name);
            if (result == null) continue;
            return result;
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findLoadedClassFromParent(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClassAll(name);
        if (result == null) {
            try {
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    parent = ClassLoader.getSystemClassLoader();
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException parent) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = this.loadClassExt(name);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    Set<String> set = this.classpaths;
                    synchronized (set) {
                        for (String classpath : this.classpaths) {
                            JARDesc desc;
                            try {
                                URL jarUrl = new URL(this.file.getCodeBase(), classpath);
                                desc = new JARDesc(jarUrl, null, null, false, true, false, true);
                            }
                            catch (MalformedURLException mfe) {
                                throw new ClassNotFoundException(name, mfe);
                            }
                            this.addNewJar(desc);
                        }
                    }
                    result = this.loadClassExt(name);
                    return result;
                }
                catch (ClassNotFoundException cnfe1) {
                    OutputController.getLogger().log(cnfe1);
                    List<JarIndex> list = this.jarIndexes;
                    synchronized (list) {
                        for (JarIndex index : this.jarIndexes) {
                            LinkedList jarList = index.get(name.replace('.', '/'));
                            if (jarList == null) continue;
                            for (String jarName : jarList) {
                                JARDesc desc;
                                try {
                                    desc = new JARDesc(new URL(this.file.getCodeBase(), jarName), null, null, false, true, false, true);
                                }
                                catch (MalformedURLException mfe) {
                                    throw new ClassNotFoundException(name);
                                }
                                try {
                                    this.addNewJar(desc);
                                }
                                catch (Exception e) {
                                    OutputController.getLogger().log(e);
                                }
                            }
                            result = this.loadClassExt(name);
                        }
                    }
                }
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private void addNewJar(JARDesc desc) {
        this.addNewJar(desc, JNLPRuntime.getDefaultUpdatePolicy());
    }

    private void addNewJar(final JARDesc desc, UpdatePolicy updatePolicy) {
        this.available.add(desc);
        this.tracker.addResource(desc.getLocation(), desc.getVersion(), null, updatePolicy);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Permission p = CacheUtil.getReadPermission(desc.getLocation(), desc.getVersion());
                JNLPClassLoader.this.resourcePermissions.add(p);
                return null;
            }
        });
        final URL remoteURL = desc.getLocation();
        URL cachedUrl = this.tracker.getCacheURL(remoteURL);
        this.available.remove(desc);
        try {
            final ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
            jars.add(desc);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    JNLPClassLoader.this.jcv.add(jars, JNLPClassLoader.this.tracker);
                    JNLPClassLoader.this.checkTrustWithUser();
                    SecurityDesc security = JNLPClassLoader.this.securityDelegate.getJarPermissions(JNLPClassLoader.this.file.getCodeBase().getHost());
                    JNLPClassLoader.this.jarLocationSecurityMap.put(remoteURL, security);
                    return null;
                }
            });
            this.addURL(remoteURL);
            CachedJarFileCallback.getInstance().addMapping(remoteURL, cachedUrl);
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (JNLPClassLoader loader : this.loaders) {
            try {
                if (loader == this) {
                    final String fName = name;
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws ClassNotFoundException {
                            return JNLPClassLoader.super.findClass(fName);
                        }
                    }, this.getAccessControlContextForClassLoading());
                }
                return loader.findClass(name);
            }
            catch (ClassNotFoundException fName) {
            }
            catch (ClassFormatError cfe) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, cfe);
            }
            catch (PrivilegedActionException cfe) {
            }
            catch (NullJnlpFileException ex) {
                throw new ClassNotFoundException(this.mainClass + " in main classloader ", ex);
            }
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findClassNonRecursive(name);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadClassExt(String name) throws ClassNotFoundException {
        this.addAvailable();
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            while (true) {
                JNLPClassLoader addedTo = null;
                try {
                    addedTo = this.addNextResource();
                }
                catch (LaunchException e) {
                    throw new IllegalStateException(e);
                }
                if (addedTo == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return addedTo.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public URL findResource(String name) {
        URL result = null;
        try {
            Enumeration<URL> e = this.findResources(name);
            if (e.hasMoreElements()) {
                result = e.nextElement();
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
        if (result == null && this.codeBaseLoader != null) {
            result = this.codeBaseLoader.findResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = this.findResourcesBySearching(name);
        try {
            while (!resources.hasMoreElements() && this.addNextResource() != null) {
                resources = this.findResourcesBySearching(name);
            }
        }
        catch (LaunchException le) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, le);
        }
        return resources;
    }

    private Enumeration<URL> findResourcesBySearching(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        Enumeration<URL> e = null;
        for (JNLPClassLoader loader : this.loaders) {
            if (loader == this) {
                final String fName = name;
                try {
                    e = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                        @Override
                        public Enumeration<URL> run() throws IOException {
                            return JNLPClassLoader.super.findResources(fName);
                        }
                    }, this.getAccessControlContextForClassLoading());
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                e = loader.findResources(name);
            }
            final Enumeration<URL> fURLEnum = e;
            try {
                resources.addAll(AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<URL>>(){

                    @Override
                    public Collection<URL> run() {
                        ArrayList<URL> resources = new ArrayList<URL>();
                        while (fURLEnum != null && fURLEnum.hasMoreElements()) {
                            resources.add((URL)fURLEnum.nextElement());
                        }
                        return resources;
                    }
                }, this.getAccessControlContextForClassLoading()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        if (resources.isEmpty() && this.codeBaseLoader != null) {
            e = this.codeBaseLoader.findResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    public boolean resourceAvailableLocally(String s) {
        return this.jarEntries.contains(s);
    }

    protected void addAvailable() {
        for (int i = 1; i < this.loaders.length; ++i) {
            this.loaders[i].addAvailable();
        }
    }

    protected JNLPClassLoader addNextResource() throws LaunchException {
        if (this.available.size() == 0) {
            for (int i = 1; i < this.loaders.length; ++i) {
                JNLPClassLoader result = this.loaders[i].addNextResource();
                if (result == null) continue;
                return result;
            }
            return null;
        }
        ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
        jars.add(this.available.get(0));
        this.fillInPartJars(jars);
        this.checkForMain(jars);
        this.activateJars(jars);
        return this;
    }

    @Deprecated
    public String getExtensionName() {
        String result = this.file.getInformation().getTitle();
        if (result == null) {
            result = this.file.getInformation().getDescription();
        }
        if (result == null && this.file.getFileLocation() != null) {
            result = this.file.getFileLocation().toString();
        }
        if (result == null && this.file.getCodeBase() != null) {
            result = this.file.getCodeBase().toString();
        }
        return result;
    }

    @Deprecated
    public String getExtensionHREF() {
        return this.file.getFileLocation().toString();
    }

    public boolean getSigning() {
        return this.signing == SigningState.FULL;
    }

    private void checkPartialSigningWithUser() {
        if (this.signing == SigningState.FULL && JNLPRuntime.isVerifying()) {
            this.signing = SigningState.PARTIAL;
            try {
                this.securityDelegate.promptUserOnPartialSigning();
            }
            catch (LaunchException e) {
                throw new RuntimeException("The signed applet required loading of unsigned code from the codebase, which the user refused", e);
            }
        }
    }

    public SigningState getSigningState() {
        return this.signing;
    }

    protected SecurityDesc getSecurity() {
        return this.security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecurityDesc getCodeSourceSecurity(URL source) {
        SecurityDesc sec = this.jarLocationSecurityMap.get(source);
        Set<URL> set = this.alreadyTried;
        synchronized (set) {
            if (sec == null && !this.alreadyTried.contains(source)) {
                this.alreadyTried.add(source);
                OutputController.getLogger().log("Application is trying to get permissions for " + source.toString() + ", which was not added by standard way. Trying to download and verify!");
                try {
                    JARDesc des = new JARDesc(source, null, null, false, false, false, false);
                    this.addNewJar(des);
                    sec = this.jarLocationSecurityMap.get(source);
                }
                catch (Throwable t) {
                    OutputController.getLogger().log(t);
                    sec = null;
                }
            }
        }
        if (sec == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("LNoSecInstance", source.toString()));
        }
        return sec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(JNLPClassLoader extLoader) {
        try {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        catch (SecurityException se) {
            throw new SecurityException("JNLPClassLoader() may only be called from trusted sources!");
        }
        for (URL u : extLoader.getURLs()) {
            this.addURL(u);
        }
        this.addToCodeBaseLoader(extLoader.file.getCodeBase());
        for (File nativeDirectory : extLoader.nativeLibraryStorage.getSearchDirectories()) {
            this.nativeLibraryStorage.addSearchDirectory(nativeDirectory);
        }
        Map<URL, SecurityDesc> map = this.jarLocationSecurityMap;
        synchronized (map) {
            for (URL key : extLoader.jarLocationSecurityMap.keySet()) {
                this.jarLocationSecurityMap.put(key, extLoader.jarLocationSecurityMap.get(key));
            }
        }
    }

    private void addToCodeBaseLoader(URL u) {
        if (u == null) {
            return;
        }
        if (!u.getFile().endsWith("/")) {
            throw new IllegalArgumentException("addToPathLoader only accepts path based URLs");
        }
        if (this.codeBaseLoader == null) {
            this.codeBaseLoader = new CodeBaseClassLoader(new URL[]{u}, this);
        } else {
            this.codeBaseLoader.addURL(u);
        }
    }

    private Set<String> getClassPathsFromManifest(Manifest mf, String originalJarPath) {
        HashSet<String> result = new HashSet<String>();
        if (mf != null) {
            String[] paths;
            String classpath = mf.getMainAttributes().getValue("Class-Path");
            if (classpath == null || classpath.trim().length() == 0) {
                return result;
            }
            for (String path : paths = classpath.split(" +")) {
                if (path.trim().length() == 0) continue;
                String dir = "";
                int lastSlash = originalJarPath.lastIndexOf("/");
                if (lastSlash != -1) {
                    dir = originalJarPath.substring(0, lastSlash + 1);
                }
                String fullPath = dir + path;
                result.add(fullPath);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(this.file.getUniqueKey());
        synchronized (reentrantLock) {
            ++this.useCount;
        }
    }

    JNLPClassLoader[] getLoaders() {
        return this.loaders;
    }

    void removeJars(JARDesc[] jars) {
        for (JARDesc eachJar : jars) {
            try {
                this.tracker.removeResource(eachJar.getLocation());
            }
            catch (Exception e) {
                OutputController.getLogger().log(e);
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Failed to remove resource from tracker, continuing..");
            }
            File cachedFile = CacheUtil.getCacheFile(eachJar.getLocation(), null);
            String directoryUrl = CacheUtil.getCacheParentDirectory(cachedFile.getAbsolutePath());
            File directory = new File(directoryUrl);
            OutputController.getLogger().log("Deleting cached file: " + cachedFile.getAbsolutePath());
            cachedFile.delete();
            OutputController.getLogger().log("Deleting cached directory: " + directory.getAbsolutePath());
            directory.delete();
        }
    }

    void initializeNewJarDownload(URL ref, String part, Version version) {
        JARDesc[] jars;
        for (JARDesc eachJar : jars = ManageJnlpResources.findJars(this, ref, part, version)) {
            OutputController.getLogger().log("Downloading and initializing jar: " + eachJar.getLocation().toString());
            this.addNewJar(eachJar, UpdatePolicy.FORCE);
        }
    }

    boolean manageExternalJars(URL ref, String version, DownloadAction action) {
        Version resourceVersion;
        boolean approved = false;
        JNLPClassLoader foundLoader = LocateJnlpClassLoader.getLoaderByResourceUrl(this, ref, version);
        Version version2 = resourceVersion = version == null ? null : new Version(version);
        if (foundLoader != null) {
            approved = true;
        } else if (ref.toString().startsWith(this.file.getCodeBase().toString())) {
            approved = true;
        } else if (SecurityDesc.ALL_PERMISSIONS.equals(this.security.getSecurityType())) {
            approved = true;
        }
        if (approved) {
            if (foundLoader == null) {
                foundLoader = this;
            }
            if (action == DownloadAction.DOWNLOAD_TO_CACHE) {
                JARDesc jarToCache = new JARDesc(ref, resourceVersion, null, false, true, false, true);
                OutputController.getLogger().log("Downloading and initializing jar: " + ref.toString());
                foundLoader.addNewJar(jarToCache, UpdatePolicy.FORCE);
            } else if (action == DownloadAction.REMOVE_FROM_CACHE) {
                JARDesc[] jarToRemove = new JARDesc[]{new JARDesc(ref, resourceVersion, null, false, true, false, true)};
                foundLoader.removeJars(jarToRemove);
            } else if (action == DownloadAction.CHECK_CACHE) {
                return CacheUtil.isCached(ref, resourceVersion);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        String uniqueKey = this.file.getUniqueKey();
        ReentrantLock reentrantLock = JNLPClassLoader.getUniqueKeyLock(uniqueKey);
        synchronized (reentrantLock) {
            --this.useCount;
            if (this.useCount <= 0) {
                uniqueKeyToLoader.remove(uniqueKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlContext getAccessControlContextForClassLoading() {
        AccessControlContext context = AccessController.getContext();
        try {
            context.checkPermission(new AllPermission());
            return context;
        }
        catch (AccessControlException accessControlException) {
            PermissionCollection permissions = this.security.getSandBoxPermissions();
            for (Permission resourcePermission : this.resourcePermissions) {
                permissions.add(resourcePermission);
            }
            Map<URL, SecurityDesc> i$ = this.jarLocationSecurityMap;
            synchronized (i$) {
                for (URL u : this.jarLocationSecurityMap.keySet()) {
                    permissions.add(new SocketPermission(u.getHost(), "connect, accept"));
                }
            }
            if (this.codeBaseLoader != null) {
                for (URL u : this.codeBaseLoader.getURLs()) {
                    permissions.add(new SocketPermission(u.getHost(), "connect, accept"));
                }
            }
            ProtectionDomain pd = new ProtectionDomain(null, permissions);
            return new AccessControlContext(new ProtectionDomain[]{pd});
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public static class CodeBaseClassLoader
    extends URLClassLoader {
        JNLPClassLoader parentJNLPClassLoader;
        ConcurrentHashMap<String, URL[]> notFoundResources = new ConcurrentHashMap();

        public CodeBaseClassLoader(URL[] urls, JNLPClassLoader cl) {
            super(urls, (ClassLoader)cl);
            this.parentJNLPClassLoader = cl;
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        Class<?> findClassNonRecursive(final String name) throws ClassNotFoundException {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(name))) {
                throw new ClassNotFoundException(name);
            }
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        Class c = CodeBaseClassLoader.super.findClass(name);
                        CodeBaseClassLoader.this.parentJNLPClassLoader.checkPartialSigningWithUser();
                        return c;
                    }
                }, this.parentJNLPClassLoader.getAccessControlContextForClassLoading());
            }
            catch (PrivilegedActionException pae) {
                this.notFoundResources.put(name, super.getURLs());
                throw new ClassNotFoundException("Could not find class " + name, pae);
            }
            catch (NullJnlpFileException njf) {
                this.notFoundResources.put(name, super.getURLs());
                throw new ClassNotFoundException("Could not find class " + name, njf);
            }
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = this.getParentJNLPClassLoader().findClass(name);
            this.parentJNLPClassLoader.checkPartialSigningWithUser();
            return c;
        }

        public Class<?> findLoadedClassFromParent(String name) {
            return this.findLoadedClass(name);
        }

        public JNLPClassLoader getParentJNLPClassLoader() {
            return this.parentJNLPClassLoader;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(name))) {
                return new Vector(0).elements();
            }
            if (!name.startsWith("META-INF")) {
                Enumeration<URL> urls = super.findResources(name);
                if (!urls.hasMoreElements()) {
                    this.notFoundResources.put(name, super.getURLs());
                }
                return urls;
            }
            return new Vector(0).elements();
        }

        @Override
        public URL findResource(String name) {
            if (Arrays.equals(super.getURLs(), this.notFoundResources.get(name))) {
                return null;
            }
            URL url = null;
            if (!name.startsWith("META-INF")) {
                try {
                    final String fName = name;
                    url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() {
                            return CodeBaseClassLoader.super.findResource(fName);
                        }
                    }, this.parentJNLPClassLoader.getAccessControlContextForClassLoading());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
                if (url == null) {
                    this.notFoundResources.put(name, super.getURLs());
                }
                return url;
            }
            return null;
        }
    }

    public static class SecurityDelegateImpl
    implements SecurityDelegate {
        private final JNLPClassLoader classLoader;
        private boolean runInSandbox;
        private boolean promptedForPartialSigning;
        private boolean promptedForSandbox;

        public SecurityDelegateImpl(JNLPClassLoader classLoader) {
            this.classLoader = classLoader;
            this.runInSandbox = false;
            this.promptedForSandbox = false;
        }

        @Override
        public boolean isPluginApplet() {
            return this.classLoader.file instanceof PluginBridge;
        }

        @Override
        public SecurityDesc getCodebaseSecurityDesc(JARDesc jarDesc, String codebaseHost) {
            if (this.runInSandbox) {
                return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
            }
            if (this.isPluginApplet()) {
                try {
                    if (JarCertVerifier.isJarSigned(jarDesc, new PluginAppVerifier(), this.classLoader.tracker)) {
                        return new SecurityDesc(this.classLoader.file, SecurityDesc.ALL_PERMISSIONS, codebaseHost);
                    }
                    return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
                }
                catch (Exception e) {
                    OutputController.getLogger().log(e);
                    return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
                }
            }
            return this.classLoader.file.getSecurity();
        }

        @Override
        public SecurityDesc getClassLoaderSecurity(String codebaseHost) throws LaunchException {
            if (this.isPluginApplet()) {
                if (!this.runInSandbox && this.classLoader.getSigning()) {
                    return new SecurityDesc(this.classLoader.file, SecurityDesc.ALL_PERMISSIONS, codebaseHost);
                }
                return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
            }
            if (!(this.runInSandbox || this.classLoader.getSigning() || this.classLoader.file.getSecurity().getSecurityType().equals(SecurityDesc.SANDBOX_PERMISSIONS))) {
                if (this.classLoader.jcv.allJarsSigned()) {
                    throw new LaunchException(this.classLoader.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedJNLPAppDifferentCerts"), Translator.R("LSignedJNLPAppDifferentCertsInfo"));
                }
                throw new LaunchException(this.classLoader.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedJarWithSecurity"), Translator.R("LUnsignedJarWithSecurityInfo"));
            }
            if (!this.runInSandbox && this.classLoader.getSigning()) {
                return this.classLoader.file.getSecurity();
            }
            return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
        }

        @Override
        public SecurityDesc getJarPermissions(String codebaseHost) {
            if (!this.runInSandbox && this.classLoader.jcv.isFullySigned()) {
                return new SecurityDesc(this.classLoader.file, SecurityDesc.ALL_PERMISSIONS, codebaseHost);
            }
            return new SecurityDesc(this.classLoader.file, SecurityDesc.SANDBOX_PERMISSIONS, codebaseHost);
        }

        @Override
        public void setRunInSandbox() throws LaunchException {
            if (this.promptedForSandbox || this.classLoader.security != null || this.classLoader.jarLocationSecurityMap.size() != 0) {
                throw new LaunchException(this.classLoader.file, null, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LRunInSandboxError"), Translator.R("LRunInSandboxErrorInfo"));
            }
            JNLPRuntime.reloadPolicy();
            this.promptedForSandbox = true;
            this.runInSandbox = true;
        }

        @Override
        public void promptUserOnPartialSigning() throws LaunchException {
            if (this.promptedForPartialSigning || JNLPRuntime.isTrustAll()) {
                return;
            }
            this.promptedForPartialSigning = true;
            UnsignedAppletTrustConfirmation.checkPartiallySignedWithUserIfRequired(this, this.classLoader.file, this.classLoader.jcv);
        }

        @Override
        public boolean getRunInSandbox() {
            return this.runInSandbox;
        }

        @Override
        public boolean userPromptedForPartialSigning() {
            return this.promptedForPartialSigning;
        }

        @Override
        public boolean userPromptedForSandbox() {
            return this.promptedForSandbox;
        }

        @Override
        public void addPermission(Permission perm) {
            this.classLoader.addPermission(perm);
        }

        @Override
        public void addPermissions(PermissionCollection perms) {
            Enumeration<Permission> e = perms.elements();
            while (e.hasMoreElements()) {
                this.addPermission(e.nextElement());
            }
        }

        @Override
        public void addPermissions(Collection<Permission> perms) {
            for (Permission perm : perms) {
                this.addPermission(perm);
            }
        }
    }

    public static interface SecurityDelegate {
        public boolean isPluginApplet();

        public boolean userPromptedForPartialSigning();

        public boolean userPromptedForSandbox();

        public SecurityDesc getCodebaseSecurityDesc(JARDesc var1, String var2);

        public SecurityDesc getClassLoaderSecurity(String var1) throws LaunchException;

        public SecurityDesc getJarPermissions(String var1);

        public void promptUserOnPartialSigning() throws LaunchException;

        public void setRunInSandbox() throws LaunchException;

        public boolean getRunInSandbox();

        public void addPermission(Permission var1);

        public void addPermissions(PermissionCollection var1);

        public void addPermissions(Collection<Permission> var1);
    }

    public static enum SigningState {
        FULL,
        PARTIAL,
        NONE;

    }

    public static enum DownloadAction {
        DOWNLOAD_TO_CACHE,
        REMOVE_FROM_CACHE,
        CHECK_CACHE;

    }
}

