/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import net.sourceforge.jnlp.config.ConfiguratonValidator;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.controlpanel.ControlPanel;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CommandLine {
    public static final int ERROR = 1;
    public static final int SUCCESS = 0;
    public final String PROGRAM_NAME = System.getProperty("icedtea-web.bin.name");
    private static final List<String> allCommands = Arrays.asList("list", "get", "set", "reset", "info", "check");
    DeploymentConfiguration config = new DeploymentConfiguration();

    public CommandLine() {
        try {
            this.config.load(false);
        }
        catch (ConfigurationException e) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("RConfigurationFatal"));
            OutputController.getLogger().log(e);
        }
    }

    public int handleHelpCommand(List<String> args) {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " " + allCommands.toString().replace(',', '|').replaceAll(" ", "") + " [help]");
        OutputController.getLogger().printOutLn(Translator.R("CLHelpDescription", this.PROGRAM_NAME));
        return 0;
    }

    public void printListHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " list [--details]");
        OutputController.getLogger().printOutLn(Translator.R("CLListDescription"));
    }

    public int handleListCommand(List<String> args) {
        if (args.contains("help")) {
            this.printListHelp();
            return 0;
        }
        boolean verbose = false;
        if (args.contains("--details")) {
            verbose = true;
            args.remove("--details");
        }
        if (args.size() != 0) {
            this.printListHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        for (String key : all.keySet()) {
            Setting<String> value = all.get(key);
            OutputController.getLogger().printOutLn(key + ": " + value.getValue());
            if (!verbose) continue;
            OutputController.getLogger().printOutLn("\t" + Translator.R("CLDescription", value.getDescription()));
        }
        return 0;
    }

    public void printGetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " get property-name");
        OutputController.getLogger().printOutLn(Translator.R("CLGetDescription"));
    }

    public int handleGetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printGetHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printGetHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        String key = args.get(0);
        String value = null;
        if (all.containsKey(key)) {
            value = all.get(key).getValue();
            OutputController.getLogger().printOutLn(value);
            return 0;
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", key));
        return 1;
    }

    public void printSetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " set property-name value");
        OutputController.getLogger().printOutLn(Translator.R("CLSetDescription"));
    }

    public int handleSetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printSetHelp();
            return 0;
        }
        if (args.size() != 2) {
            this.printSetHelp();
            return 1;
        }
        String key = args.get(0);
        String value = args.get(1);
        if (this.config.getRaw().containsKey(key)) {
            Setting<String> old = this.config.getRaw().get(key);
            if (old.getValidator() != null) {
                try {
                    old.getValidator().validate(value);
                }
                catch (IllegalArgumentException e) {
                    OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("CLIncorrectValue", old.getName(), value, old.getValidator().getPossibleValues()));
                    OutputController.getLogger().log(e);
                    return 1;
                }
            }
            this.config.setProperty(key, value);
        } else {
            OutputController.getLogger().printOutLn(Translator.R("CLWarningUnknownProperty", key));
            this.config.setProperty(key, value);
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return 1;
        }
        return 0;
    }

    public void printResetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " reset [all|property-name]");
        OutputController.getLogger().printOutLn(Translator.R("CLResetDescription"));
    }

    public int handleResetCommand(List<String> args) {
        if (args.contains("help")) {
            this.printResetHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printResetHelp();
            return 1;
        }
        String key = args.get(0);
        boolean resetAll = false;
        if (key.equals("all")) {
            resetAll = true;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        if (!resetAll && !all.containsKey(key)) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", key));
            return 1;
        }
        if (resetAll) {
            for (String aKey : all.keySet()) {
                Setting<String> setting = all.get(aKey);
                setting.setValue(setting.getDefaultValue());
            }
        } else {
            Setting<String> setting = all.get(key);
            setting.setValue(setting.getDefaultValue());
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return 1;
        }
        return 0;
    }

    public void printInfoHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " info property-name");
        OutputController.getLogger().printOutLn(Translator.R("CLInfoDescription"));
    }

    public int handleInfoCommand(List<String> args) {
        String key;
        if (args.contains("help")) {
            this.printInfoHelp();
            return 0;
        }
        if (args.size() != 1) {
            this.printInfoHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        Setting<String> value = all.get(key = args.get(0));
        if (value == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLNoInfo"));
            return 1;
        }
        OutputController.getLogger().printOutLn(Translator.R("CLDescription", value.getDescription()));
        OutputController.getLogger().printOutLn(Translator.R("CLValue", value.getValue()));
        if (value.getValidator() != null) {
            OutputController.getLogger().printOutLn("\t" + Translator.R("VVPossibleValues", value.getValidator().getPossibleValues()));
        }
        OutputController.getLogger().printOutLn(Translator.R("CLValueSource", value.getSource()));
        return 0;
    }

    public void printCheckHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " check");
        OutputController.getLogger().printOutLn(Translator.R("CLCheckDescription"));
    }

    public int handleCheckCommand(List<String> args) {
        if (args.contains("help")) {
            this.printCheckHelp();
            return 0;
        }
        if (args.size() != 0) {
            this.printCheckHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        ConfiguratonValidator validator = new ConfiguratonValidator(all);
        validator.validate();
        boolean allValid = true;
        for (Setting<String> setting : validator.getIncorrectSetting()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLIncorrectValue", setting.getName(), setting.getValue(), setting.getValidator().getPossibleValues()));
            allValid = false;
        }
        for (Setting<String> setting : validator.getUnrecognizedSetting()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", setting.getName()));
            allValid = false;
        }
        if (allValid) {
            OutputController.getLogger().printOutLn(Translator.R("CLNoIssuesFound"));
            return 0;
        }
        return 1;
    }

    public int handle(String[] commandAndArgs) {
        int val;
        if (commandAndArgs == null) {
            throw new NullPointerException("command is null");
        }
        if (commandAndArgs.length == 0) {
            this.handleHelpCommand(new ArrayList<String>());
            return 1;
        }
        String command = commandAndArgs[0];
        String[] argsArray = new String[commandAndArgs.length - 1];
        System.arraycopy(commandAndArgs, 1, argsArray, 0, commandAndArgs.length - 1);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(argsArray));
        if (command.equals("help")) {
            val = this.handleHelpCommand(arguments);
        } else if (command.equals("list")) {
            val = this.handleListCommand(arguments);
        } else if (command.equals("set")) {
            val = this.handleSetCommand(arguments);
        } else if (command.equals("reset")) {
            val = this.handleResetCommand(arguments);
        } else if (command.equals("get")) {
            val = this.handleGetCommand(arguments);
        } else if (command.equals("info")) {
            val = this.handleInfoCommand(arguments);
        } else if (command.equals("check")) {
            val = this.handleCheckCommand(arguments);
        } else if (allCommands.contains(command)) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "INTERNAL ERROR: " + command + " should have been implemented");
            val = 1;
        } else {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownCommand", command));
            this.handleHelpCommand(new ArrayList<String>());
            val = 1;
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        if (args.length == 0) {
            ControlPanel.main(new String[0]);
        } else {
            CommandLine cli = new CommandLine();
            int result = cli.handle(args);
            JNLPRuntime.exit(result);
        }
    }
}

