/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateCertificatesTest {
    private static final String ALIAS_CACERT = "debian:thawte_Primary_Root_CA_-_G3.crt";
    private static final String INVALID_CACERT = "x/usr/share/ca-certificates/mozilla/thawte_Primary_Root_CA_-_G3.crt";
    private static final String REMOVE_CACERT = "-/usr/share/ca-certificates/mozilla/thawte_Primary_Root_CA_-_G3.crt";
    private static final String ADD_CACERT = "+/usr/share/ca-certificates/mozilla/thawte_Primary_Root_CA_-_G3.crt";
    private String ksFilename = null;
    private String ksPassword = null;

    @Before
    public void start() {
        this.ksFilename = "./tests-cacerts";
        this.ksPassword = "changeit";
        File file = new File(this.ksFilename);
        file.delete();
    }

    @Test
    public void testNoop() throws IOException, GeneralSecurityException, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.writeKeyStore();
    }

    @Test
    public void testWriteThenOpenWrongPwd() throws IOException, GeneralSecurityException, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates;
        try {
            updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
            updateCertificates.writeKeyStore();
        }
        catch (Exceptions.InvalidKeystorePassword invalidKeystorePassword) {
            Assert.fail();
        }
        try {
            updateCertificates = new UpdateCertificates("wrongpassword", this.ksFilename);
            Assert.fail();
            updateCertificates.writeKeyStore();
        }
        catch (Exceptions.InvalidKeystorePassword invalidKeystorePassword) {
            Assert.assertEquals((String)"Cannot open Java keystore. Is the password correct?", (String)invalidKeystorePassword.getMessage());
        }
    }

    @Test
    public void testDeleteThenWrite() throws IOException, GeneralSecurityException, Exceptions.InvalidKeystorePassword {
        try {
            UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
            File file = new File(this.ksFilename);
            file.delete();
            file.mkdir();
            updateCertificates.writeKeyStore();
            Assert.fail();
        }
        catch (Exceptions.UnableToSaveKeystore unableToSaveKeystore) {
            Assert.assertEquals((String)"There was a problem saving the new Java keystore.", (String)unableToSaveKeystore.getMessage());
        }
    }

    @Test
    public void testWrongCommand() throws IOException, GeneralSecurityException, Exceptions.InvalidKeystorePassword {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        try {
            updateCertificates.parseLine(INVALID_CACERT);
            Assert.fail();
        }
        catch (Exceptions.UnknownInput unknownInput) {
            Assert.assertEquals((String)INVALID_CACERT, (String)unknownInput.getMessage());
        }
    }

    @Test
    public void testAdd() throws IOException, GeneralSecurityException, Exceptions.UnknownInput, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.parseLine(ADD_CACERT);
        updateCertificates.writeKeyStore();
        Assert.assertEquals((boolean)true, (boolean)updateCertificates.contains(ALIAS_CACERT));
    }

    @Test
    public void testAddInvalidCert() throws IOException, GeneralSecurityException, Exceptions.UnknownInput, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.parseLine("+/usr/share/ca-certificates/null.crt");
        updateCertificates.writeKeyStore();
        Assert.assertEquals((boolean)false, (boolean)updateCertificates.contains("debian:null.crt"));
    }

    @Test
    public void testReplace() throws IOException, GeneralSecurityException, Exceptions.UnknownInput, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.parseLine(ADD_CACERT);
        updateCertificates.parseLine(ADD_CACERT);
        updateCertificates.writeKeyStore();
        Assert.assertEquals((boolean)true, (boolean)updateCertificates.contains(ALIAS_CACERT));
    }

    @Test
    public void testRemove() throws IOException, GeneralSecurityException, Exceptions.UnknownInput, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.parseLine(REMOVE_CACERT);
        updateCertificates.writeKeyStore();
        Assert.assertEquals((boolean)false, (boolean)updateCertificates.contains(ALIAS_CACERT));
    }

    @Test
    public void testAddThenRemove() throws IOException, GeneralSecurityException, Exceptions.UnknownInput, Exceptions.InvalidKeystorePassword, Exceptions.UnableToSaveKeystore {
        UpdateCertificates updateCertificates = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates.parseLine(ADD_CACERT);
        updateCertificates.writeKeyStore();
        Assert.assertEquals((boolean)true, (boolean)updateCertificates.contains(ALIAS_CACERT));
        UpdateCertificates updateCertificates2 = new UpdateCertificates(this.ksPassword, this.ksFilename);
        updateCertificates2.parseLine(REMOVE_CACERT);
        updateCertificates2.writeKeyStore();
        Assert.assertEquals((boolean)false, (boolean)updateCertificates2.contains(ALIAS_CACERT));
    }
}

