
#--------------------------------------------------------------
# 
# R-interface to ADMB-RE routines to generalized linear mixed models (GLMM)
#  
# File: glmmadmb.s 
# Makes use of: nbmm.dll (windows) or nbmm.so (linux)
# 
# Date: March, 2005
# 
#--------------------------------------------------------------


# Function for invoking ADMB
glmm.admb <- function(fixed,random,group,data)
{ 
  n <- nrow(data)
  y <- data[[as.character(fixed[2])]]

  # Fixed effects model matrix
  X <- model.matrix(fixed,data)
  p <- ncol(X)

  # Fixed effects model matrix
  Z <- model.matrix(random,data)
  m <- ncol(Z)

  # Random effects model matrix
  if(!(is.character(group) & (length(group)==1)))
    stop("The argument \"group\" must currently be a string spesifying the name of the grouping variable")
  tmpu <- table(data[[group]])
  tmpu[] <- 1:length(tmpu)
  II <- tmpu[as.character(data[["subject"]])]
  q <- length(unique(II))

  if(!is.loaded("nbmm"))
    dyn.load(paste("nbmm",.Platform$dynlib.ext,sep=""))

  out <- .C("nbmm",
  	as.integer(n),
  	as.double(y),
  	as.integer(p),
  	as.double(X),
  	as.integer(q),
  	as.integer(m),
  	as.double(Z),
  	as.double(II),
  	b=as.double(numeric(p)),
  	tmpL=as.double(numeric(m*(m+1)/2)),
  	logalpha=as.double(0),
          " -maxfn 500 ")
# the -est option turns off calculation of the Hessian and standard deviations
#         " -maxfn 500 -est ")

#   L <- matrix(0,m,m)		# Cholesky factor of covariance matrix
#   L[1,1] <- exp(out$tmpL[1])
# 
#   if(m>1) 
#   {
#     L[2,2] <- exp(out$tmpL[3])/sqrt(1+out$tmpL[2]*out$tmpL[2]) 
#     L[2,1] <- out$tmpL[2] * L[2,2]
#   }
# 


  L <- matrix(0,m,m)		# Cholesky factor of covariance matrix

  L[1,1] <- exp(out$tmpL[1])
  if(m>1)
  {
    ii <- m+1
    for(i in 2:m)
    {
      tmp <- 1 
      for(j in 1:(i-1))
      {
        tmp <- tmp + out$tmpL[ii]*out$tmpL[ii]
        L[i,j] <- out$tmpL[ii]
        ii <- ii + 1
      }
      tmp <- sqrt(tmp)
      L[i,i] <- exp(out$tmpL[i])/tmp
      for(j in 1:(i-1))
      {
        L[i,j] <- exp(out$tmpL[i])*L[i,j]/tmp
      }
    }
  }
  
  dyn.unload(paste("nbmm",.Platform$dynlib.ext,sep=""))
  
  list(b=out$b,S=L%*%t(L),alpha=exp(out$logalpha))
}


# Modified version of the "epil"-data from MASS
"epil2" <-
structure(list(y = as.integer(c(5, 3, 3, 3, 3, 5, 3, 3, 2, 4, 
0, 5, 4, 4, 1, 4, 7, 18, 9, 21, 5, 2, 8, 7, 6, 4, 0, 2, 40, 20, 
21, 12, 5, 6, 6, 5, 14, 13, 6, 0, 26, 12, 6, 22, 12, 6, 8, 4, 
4, 4, 6, 2, 7, 9, 12, 14, 16, 24, 10, 9, 11, 0, 0, 5, 0, 0, 3, 
3, 37, 29, 28, 29, 3, 5, 2, 5, 3, 0, 6, 7, 3, 4, 3, 4, 3, 4, 
3, 4, 2, 3, 3, 5, 8, 12, 2, 8, 18, 24, 76, 25, 2, 1, 2, 1, 3, 
1, 4, 2, 13, 15, 13, 12, 11, 14, 9, 8, 8, 7, 9, 4, 0, 4, 3, 0, 
3, 6, 1, 3, 2, 6, 7, 4, 4, 3, 1, 3, 22, 17, 19, 16, 5, 4, 7, 
4, 2, 4, 0, 4, 3, 7, 7, 7, 4, 18, 2, 5, 2, 1, 1, 0, 0, 2, 4, 
0, 5, 4, 0, 3, 11, 14, 25, 15, 10, 5, 3, 8, 19, 7, 6, 7, 1, 1, 
2, 3, 6, 10, 8, 8, 2, 1, 0, 0, 102, 65, 72, 63, 4, 3, 2, 4, 8, 
6, 5, 7, 1, 3, 1, 5, 18, 11, 28, 13, 6, 3, 4, 0, 3, 5, 4, 3, 
1, 23, 19, 8, 2, 3, 0, 1, 0, 0, 0, 0, 1, 4, 3, 2)), trt = structure(as.integer(c(1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2)), .Label = c("placebo", "progabide"), class = "factor"), 
    base = as.integer(c(11, 11, 11, 11, 11, 11, 11, 11, 6, 6, 
    6, 6, 8, 8, 8, 8, 66, 66, 66, 66, 27, 27, 27, 27, 12, 12, 
    12, 12, 52, 52, 52, 52, 23, 23, 23, 23, 10, 10, 10, 10, 52, 
    52, 52, 52, 33, 33, 33, 33, 18, 18, 18, 18, 42, 42, 42, 42, 
    87, 87, 87, 87, 50, 50, 50, 50, 18, 18, 18, 18, 111, 111, 
    111, 111, 18, 18, 18, 18, 20, 20, 20, 20, 12, 12, 12, 12, 
    9, 9, 9, 9, 17, 17, 17, 17, 28, 28, 28, 28, 55, 55, 55, 55, 
    9, 9, 9, 9, 10, 10, 10, 10, 47, 47, 47, 47, 76, 76, 76, 76, 
    38, 38, 38, 38, 19, 19, 19, 19, 10, 10, 10, 10, 19, 19, 19, 
    19, 24, 24, 24, 24, 31, 31, 31, 31, 14, 14, 14, 14, 11, 11, 
    11, 11, 67, 67, 67, 67, 41, 41, 41, 41, 7, 7, 7, 7, 22, 22, 
    22, 22, 13, 13, 13, 13, 46, 46, 46, 46, 36, 36, 36, 36, 38, 
    38, 38, 38, 7, 7, 7, 7, 36, 36, 36, 36, 11, 11, 11, 11, 151, 
    151, 151, 151, 22, 22, 22, 22, 41, 41, 41, 41, 32, 32, 32, 
    32, 56, 56, 56, 56, 24, 24, 24, 24, 16, 16, 16, 16, 22, 22, 
    22, 22, 25, 25, 25, 25, 13, 13, 13, 13, 12, 12, 12, 12)), 
    age = as.integer(c(31, 31, 31, 31, 30, 30, 30, 30, 25, 25, 
    25, 25, 36, 36, 36, 36, 22, 22, 22, 22, 29, 29, 29, 29, 31, 
    31, 31, 31, 42, 42, 42, 42, 37, 37, 37, 37, 28, 28, 28, 28, 
    36, 36, 36, 36, 24, 24, 24, 24, 23, 23, 23, 23, 36, 36, 36, 
    36, 26, 26, 26, 26, 26, 26, 26, 26, 28, 28, 28, 28, 31, 31, 
    31, 31, 32, 32, 32, 32, 21, 21, 21, 21, 29, 29, 29, 29, 21, 
    21, 21, 21, 32, 32, 32, 32, 25, 25, 25, 25, 30, 30, 30, 30, 
    40, 40, 40, 40, 19, 19, 19, 19, 22, 22, 22, 22, 18, 18, 18, 
    18, 32, 32, 32, 32, 20, 20, 20, 20, 30, 30, 30, 30, 18, 18, 
    18, 18, 24, 24, 24, 24, 30, 30, 30, 30, 35, 35, 35, 35, 27, 
    27, 27, 27, 20, 20, 20, 20, 22, 22, 22, 22, 28, 28, 28, 28, 
    23, 23, 23, 23, 40, 40, 40, 40, 33, 33, 33, 33, 21, 21, 21, 
    21, 35, 35, 35, 35, 25, 25, 25, 25, 26, 26, 26, 26, 25, 25, 
    25, 25, 22, 22, 22, 22, 32, 32, 32, 32, 25, 25, 25, 25, 35, 
    35, 35, 35, 21, 21, 21, 21, 41, 41, 41, 41, 32, 32, 32, 32, 
    26, 26, 26, 26, 21, 21, 21, 21, 36, 36, 36, 36, 37, 37, 37, 
    37)), V4 = as.integer(c(0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
    1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
    0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
    0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
    0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
    1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
    0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
    0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
    0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
    1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
    0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
    0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
    0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1)), subject = as.integer(c(1, 
    1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 
    6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 
    10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 
    14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 
    18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 
    22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 
    25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 
    29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 
    33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35, 36, 36, 36, 36, 
    37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39, 40, 40, 40, 
    40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43, 44, 44, 
    44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47, 48, 
    48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 51, 
    52, 52, 52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 
    55, 56, 56, 56, 56, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 
    59, 59)), period = as.integer(c(1, 2, 3, 4, 1, 2, 3, 4, 1, 
    2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 
    1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 
    4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 
    3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 
    2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 
    1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 
    4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 
    3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 
    2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 
    1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 
    4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 
    3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4)), lbase = c(-0.756353788717556, 
    -0.756353788717556, -0.756353788717556, -0.756353788717556, 
    -0.756353788717556, -0.756353788717556, -0.756353788717556, 
    -0.756353788717556, -1.36248959228787, -1.36248959228787, 
    -1.36248959228787, -1.36248959228787, -1.07480751983609, 
    -1.07480751983609, -1.07480751983609, -1.07480751983609, 
    1.0354056805105, 1.0354056805105, 1.0354056805105, 1.0354056805105, 
    0.141587804488402, 0.141587804488402, 0.141587804488402, 
    0.141587804488402, -0.669342411727926, -0.669342411727926, 
    -0.669342411727926, -0.669342411727926, 0.7969946570655, 
    0.7969946570655, 0.7969946570655, 0.7969946570655, -0.018754845586777, 
    -0.018754845586777, -0.018754845586777, -0.018754845586777, 
    -0.851663968521881, -0.851663968521881, -0.851663968521881, 
    -0.851663968521881, 0.7969946570655, 0.7969946570655, 0.7969946570655, 
    0.7969946570655, 0.342258499950553, 0.342258499950553, 0.342258499950553, 
    0.342258499950553, -0.263877303619762, -0.263877303619762, 
    -0.263877303619762, -0.263877303619762, 0.583420556767442, 
    0.583420556767442, 0.583420556767442, 0.583420556767442, 
    1.31165905713866, 1.31165905713866, 1.31165905713866, 1.31165905713866, 
    0.75777394391222, 0.75777394391222, 0.75777394391222, 0.75777394391222, 
    -0.263877303619762, -0.263877303619762, -0.263877303619762, 
    -0.263877303619762, 1.55528113979641, 1.55528113979641, 1.55528113979641, 
    1.55528113979641, -0.263877303619762, -0.263877303619762, 
    -0.263877303619762, -0.263877303619762, -0.158516787961936, 
    -0.158516787961936, -0.158516787961936, -0.158516787961936, 
    -0.669342411727926, -0.669342411727926, -0.669342411727926, 
    -0.669342411727926, -0.957024484179707, -0.957024484179707, 
    -0.957024484179707, -0.957024484179707, -0.321035717459711, 
    -0.321035717459711, -0.321035717459711, -0.321035717459711, 
    0.177955448659277, 0.177955448659277, 0.177955448659277, 
    0.177955448659277, 0.853084123716544, 0.853084123716544, 
    0.853084123716544, 0.853084123716544, -0.957024484179707, 
    -0.957024484179707, -0.957024484179707, -0.957024484179707, 
    -0.851663968521881, -0.851663968521881, -0.851663968521881, 
    -0.851663968521881, 0.695898540194132, 0.695898540194132, 
    0.695898540194132, 0.695898540194132, 1.1764842787704, 1.1764842787704, 
    1.1764842787704, 1.1764842787704, 0.483337098210459, 0.483337098210459, 
    0.483337098210459, 0.483337098210459, -0.209810082349486, 
    -0.209810082349486, -0.209810082349486, -0.209810082349486, 
    -0.851663968521881, -0.851663968521881, -0.851663968521881, 
    -0.851663968521881, -0.209810082349486, -0.209810082349486, 
    -0.209810082349486, -0.209810082349486, 0.0238047688320189, 
    0.0238047688320189, 0.0238047688320189, 0.0238047688320189, 
    0.279738142969219, 0.279738142969219, 0.279738142969219, 
    0.279738142969219, -0.515191731900668, -0.515191731900668, 
    -0.515191731900668, -0.515191731900668, -0.756353788717556, 
    -0.756353788717556, -0.756353788717556, -0.756353788717556, 
    1.05044355787504, 1.05044355787504, 1.05044355787504, 1.05044355787504, 
    0.559323005188381, 0.559323005188381, 0.559323005188381, 
    0.559323005188381, -1.20833891246061, -1.20833891246061, 
    -1.20833891246061, -1.20833891246061, -0.0632066081576108, 
    -0.0632066081576108, -0.0632066081576108, -0.0632066081576108, 
    -0.58929970405439, -0.58929970405439, -0.58929970405439, 
    -0.58929970405439, 0.674392334973168, 0.674392334973168, 
    0.674392334973168, 0.674392334973168, 0.429269876940183, 
    0.429269876940183, 0.429269876940183, 0.429269876940183, 
    0.483337098210459, 0.483337098210459, 0.483337098210459, 
    0.483337098210459, -1.20833891246061, -1.20833891246061, 
    -1.20833891246061, -1.20833891246061, 0.429269876940183, 
    0.429269876940183, 0.429269876940183, 0.429269876940183, 
    -0.756353788717556, -0.756353788717556, -0.756353788717556, 
    -0.756353788717556, 1.863030775299, 1.863030775299, 1.863030775299, 
    1.863030775299, -0.0632066081576108, -0.0632066081576108, 
    -0.0632066081576108, -0.0632066081576108, 0.559323005188381, 
    0.559323005188381, 0.559323005188381, 0.559323005188381, 
    0.3114868412838, 0.3114868412838, 0.3114868412838, 0.3114868412838, 
    0.871102629219222, 0.871102629219222, 0.871102629219222, 
    0.871102629219222, 0.0238047688320189, 0.0238047688320189, 
    0.0238047688320189, 0.0238047688320189, -0.381660339276146, 
    -0.381660339276146, -0.381660339276146, -0.381660339276146, 
    -0.0632066081576108, -0.0632066081576108, -0.0632066081576108, 
    -0.0632066081576108, 0.0646267633522741, 0.0646267633522741, 
    0.0646267633522741, 0.0646267633522741, -0.58929970405439, 
    -0.58929970405439, -0.58929970405439, -0.58929970405439, 
    -0.669342411727926, -0.669342411727926, -0.669342411727926, 
    -0.669342411727926), lage = c(0.114203695299265, 0.114203695299265, 
    0.114203695299265, 0.114203695299265, 0.0814138724762743, 
    0.0814138724762743, 0.0814138724762743, 0.0814138724762743, 
    -0.10090768431768, -0.10090768431768, -0.10090768431768, 
    -0.10090768431768, 0.263735429270229, 0.263735429270229, 
    0.263735429270229, 0.263735429270229, -0.228741055827565, 
    -0.228741055827565, -0.228741055827565, -0.228741055827565, 
    0.047512320800593, 0.047512320800593, 0.047512320800593, 
    0.047512320800593, 0.114203695299265, 0.114203695299265, 
    0.114203695299265, 0.114203695299265, 0.417886109097487, 
    0.417886109097487, 0.417886109097487, 0.417886109097487, 
    0.291134403458343, 0.291134403458343, 0.291134403458343, 
    0.291134403458343, 0.0124210009893226, 0.0124210009893226, 
    0.0124210009893226, 0.0124210009893226, 0.263735429270229, 
    0.263735429270229, 0.263735429270229, 0.263735429270229, 
    -0.141729678837935, -0.141729678837935, -0.141729678837935, 
    -0.141729678837935, -0.184289293256731, -0.184289293256731, 
    -0.184289293256731, -0.184289293256731, 0.263735429270229, 
    0.263735429270229, 0.263735429270229, 0.263735429270229, 
    -0.061686971164399, -0.061686971164399, -0.061686971164399, 
    -0.061686971164399, -0.061686971164399, -0.061686971164399, 
    -0.061686971164399, -0.061686971164399, 0.0124210009893226, 
    0.0124210009893226, 0.0124210009893226, 0.0124210009893226, 
    0.114203695299265, 0.114203695299265, 0.114203695299265, 
    0.114203695299265, 0.145952393613845, 0.145952393613845, 
    0.145952393613845, 0.145952393613845, -0.275261071462458, 
    -0.275261071462458, -0.275261071462458, -0.275261071462458, 
    0.047512320800593, 0.047512320800593, 0.047512320800593, 
    0.047512320800593, -0.275261071462458, -0.275261071462458, 
    -0.275261071462458, -0.275261071462458, 0.145952393613845, 
    0.145952393613845, 0.145952393613845, 0.145952393613845, 
    -0.10090768431768, -0.10090768431768, -0.10090768431768, 
    -0.10090768431768, 0.0814138724762743, 0.0814138724762743, 
    0.0814138724762743, 0.0814138724762743, 0.369095944928055, 
    0.369095944928055, 0.369095944928055, 0.369095944928055, 
    -0.375344530019441, -0.375344530019441, -0.375344530019441, 
    -0.375344530019441, -0.228741055827565, -0.228741055827565, 
    -0.228741055827565, -0.228741055827565, -0.429411751289717, 
    -0.429411751289717, -0.429411751289717, -0.429411751289717, 
    0.145952393613845, 0.145952393613845, 0.145952393613845, 
    0.145952393613845, -0.32405123563189, -0.32405123563189, 
    -0.32405123563189, -0.32405123563189, 0.0814138724762743, 
    0.0814138724762743, 0.0814138724762743, 0.0814138724762743, 
    -0.429411751289717, -0.429411751289717, -0.429411751289717, 
    -0.429411751289717, -0.141729678837935, -0.141729678837935, 
    -0.141729678837935, -0.141729678837935, 0.0814138724762743, 
    0.0814138724762743, 0.0814138724762743, 0.0814138724762743, 
    0.235564552303532, 0.235564552303532, 0.235564552303532, 
    0.235564552303532, -0.023946643181552, -0.023946643181552, 
    -0.023946643181552, -0.023946643181552, -0.32405123563189, 
    -0.32405123563189, -0.32405123563189, -0.32405123563189, 
    -0.228741055827565, -0.228741055827565, -0.228741055827565, 
    -0.228741055827565, 0.0124210009893226, 0.0124210009893226, 
    0.0124210009893226, 0.0124210009893226, -0.184289293256731, 
    -0.184289293256731, -0.184289293256731, -0.184289293256731, 
    0.369095944928055, 0.369095944928055, 0.369095944928055, 
    0.369095944928055, 0.176724052280599, 0.176724052280599, 
    0.176724052280599, 0.176724052280599, -0.275261071462458, 
    -0.275261071462458, -0.275261071462458, -0.275261071462458, 
    0.235564552303532, 0.235564552303532, 0.235564552303532, 
    0.235564552303532, -0.10090768431768, -0.10090768431768, 
    -0.10090768431768, -0.10090768431768, -0.061686971164399, 
    -0.061686971164399, -0.061686971164399, -0.061686971164399, 
    -0.10090768431768, -0.10090768431768, -0.10090768431768, 
    -0.10090768431768, -0.228741055827565, -0.228741055827565, 
    -0.228741055827565, -0.228741055827565, 0.145952393613845, 
    0.145952393613845, 0.145952393613845, 0.145952393613845, 
    -0.10090768431768, -0.10090768431768, -0.10090768431768, 
    -0.10090768431768, 0.235564552303532, 0.235564552303532, 
    0.235564552303532, 0.235564552303532, -0.275261071462458, 
    -0.275261071462458, -0.275261071462458, -0.275261071462458, 
    0.393788557518427, 0.393788557518427, 0.393788557518427, 
    0.393788557518427, 0.145952393613845, 0.145952393613845, 
    0.145952393613845, 0.145952393613845, -0.061686971164399, 
    -0.061686971164399, -0.061686971164399, -0.061686971164399, 
    -0.275261071462458, -0.275261071462458, -0.275261071462458, 
    -0.275261071462458, 0.263735429270229, 0.263735429270229, 
    0.263735429270229, 0.263735429270229, 0.291134403458343, 
    0.291134403458343, 0.291134403458343, 0.291134403458343), 
    Visit = c(-0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, 
    -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 
    0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 
    0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, 
    -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 
    0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 
    0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, 
    -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 
    0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 
    0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, 
    -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 
    0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 
    0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, 
    -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 
    0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 
    0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3, -0.3, 
    -0.1, 0.1, 0.3, -0.3, -0.1, 0.1, 0.3), Base = c(1.01160091167848, 
    1.01160091167848, 1.01160091167848, 1.01160091167848, 1.01160091167848, 
    1.01160091167848, 1.01160091167848, 1.01160091167848, 0.405465108108164, 
    0.405465108108164, 0.405465108108164, 0.405465108108164, 
    0.693147180559945, 0.693147180559945, 0.693147180559945, 
    0.693147180559945, 2.80336038090653, 2.80336038090653, 2.80336038090653, 
    2.80336038090653, 1.90954250488444, 1.90954250488444, 1.90954250488444, 
    1.90954250488444, 1.09861228866811, 1.09861228866811, 1.09861228866811, 
    1.09861228866811, 2.56494935746154, 2.56494935746154, 2.56494935746154, 
    2.56494935746154, 1.74919985480926, 1.74919985480926, 1.74919985480926, 
    1.74919985480926, 0.916290731874155, 0.916290731874155, 0.916290731874155, 
    0.916290731874155, 2.56494935746154, 2.56494935746154, 2.56494935746154, 
    2.56494935746154, 2.11021320034659, 2.11021320034659, 2.11021320034659, 
    2.11021320034659, 1.50407739677627, 1.50407739677627, 1.50407739677627, 
    1.50407739677627, 2.35137525716348, 2.35137525716348, 2.35137525716348, 
    2.35137525716348, 3.07961375753469, 3.07961375753469, 3.07961375753469, 
    3.07961375753469, 2.52572864430826, 2.52572864430826, 2.52572864430826, 
    2.52572864430826, 1.50407739677627, 1.50407739677627, 1.50407739677627, 
    1.50407739677627, 3.32323584019244, 3.32323584019244, 3.32323584019244, 
    3.32323584019244, 1.50407739677627, 1.50407739677627, 1.50407739677627, 
    1.50407739677627, 1.6094379124341, 1.6094379124341, 1.6094379124341, 
    1.6094379124341, 1.09861228866811, 1.09861228866811, 1.09861228866811, 
    1.09861228866811, 0.810930216216329, 0.810930216216329, 0.810930216216329, 
    0.810930216216329, 1.44691898293633, 1.44691898293633, 1.44691898293633, 
    1.44691898293633, 1.94591014905531, 1.94591014905531, 1.94591014905531, 
    1.94591014905531, 2.62103882411258, 2.62103882411258, 2.62103882411258, 
    2.62103882411258, 0.810930216216329, 0.810930216216329, 0.810930216216329, 
    0.810930216216329, 0.916290731874155, 0.916290731874155, 
    0.916290731874155, 0.916290731874155, 2.46385324059017, 2.46385324059017, 
    2.46385324059017, 2.46385324059017, 2.94443897916644, 2.94443897916644, 
    2.94443897916644, 2.94443897916644, 2.2512917986065, 2.2512917986065, 
    2.2512917986065, 2.2512917986065, 1.55814461804655, 1.55814461804655, 
    1.55814461804655, 1.55814461804655, 0.916290731874155, 0.916290731874155, 
    0.916290731874155, 0.916290731874155, 1.55814461804655, 1.55814461804655, 
    1.55814461804655, 1.55814461804655, 1.79175946922806, 1.79175946922806, 
    1.79175946922806, 1.79175946922806, 2.04769284336526, 2.04769284336526, 
    2.04769284336526, 2.04769284336526, 1.25276296849537, 1.25276296849537, 
    1.25276296849537, 1.25276296849537, 1.01160091167848, 1.01160091167848, 
    1.01160091167848, 1.01160091167848, 2.81839825827108, 2.81839825827108, 
    2.81839825827108, 2.81839825827108, 2.32727770558442, 2.32727770558442, 
    2.32727770558442, 2.32727770558442, 0.559615787935423, 0.559615787935423, 
    0.559615787935423, 0.559615787935423, 1.70474809223843, 1.70474809223843, 
    1.70474809223843, 1.70474809223843, 1.17865499634165, 1.17865499634165, 
    1.17865499634165, 1.17865499634165, 2.4423470353692, 2.4423470353692, 
    2.4423470353692, 2.4423470353692, 2.19722457733622, 2.19722457733622, 
    2.19722457733622, 2.19722457733622, 2.2512917986065, 2.2512917986065, 
    2.2512917986065, 2.2512917986065, 0.559615787935423, 0.559615787935423, 
    0.559615787935423, 0.559615787935423, 2.19722457733622, 2.19722457733622, 
    2.19722457733622, 2.19722457733622, 1.01160091167848, 1.01160091167848, 
    1.01160091167848, 1.01160091167848, 3.63098547569503, 3.63098547569503, 
    3.63098547569503, 3.63098547569503, 1.70474809223843, 1.70474809223843, 
    1.70474809223843, 1.70474809223843, 2.32727770558442, 2.32727770558442, 
    2.32727770558442, 2.32727770558442, 2.07944154167984, 2.07944154167984, 
    2.07944154167984, 2.07944154167984, 2.63905732961526, 2.63905732961526, 
    2.63905732961526, 2.63905732961526, 1.79175946922806, 1.79175946922806, 
    1.79175946922806, 1.79175946922806, 1.38629436111989, 1.38629436111989, 
    1.38629436111989, 1.38629436111989, 1.70474809223843, 1.70474809223843, 
    1.70474809223843, 1.70474809223843, 1.83258146374831, 1.83258146374831, 
    1.83258146374831, 1.83258146374831, 1.17865499634165, 1.17865499634165, 
    1.17865499634165, 1.17865499634165, 1.09861228866811, 1.09861228866811, 
    1.09861228866811, 1.09861228866811), Age = c(3.43398720448515, 
    3.43398720448515, 3.43398720448515, 3.43398720448515, 3.40119738166216, 
    3.40119738166216, 3.40119738166216, 3.40119738166216, 3.2188758248682, 
    3.2188758248682, 3.2188758248682, 3.2188758248682, 3.58351893845611, 
    3.58351893845611, 3.58351893845611, 3.58351893845611, 3.09104245335832, 
    3.09104245335832, 3.09104245335832, 3.09104245335832, 3.36729582998647, 
    3.36729582998647, 3.36729582998647, 3.36729582998647, 3.43398720448515, 
    3.43398720448515, 3.43398720448515, 3.43398720448515, 3.73766961828337, 
    3.73766961828337, 3.73766961828337, 3.73766961828337, 3.61091791264422, 
    3.61091791264422, 3.61091791264422, 3.61091791264422, 3.3322045101752, 
    3.3322045101752, 3.3322045101752, 3.3322045101752, 3.58351893845611, 
    3.58351893845611, 3.58351893845611, 3.58351893845611, 3.17805383034795, 
    3.17805383034795, 3.17805383034795, 3.17805383034795, 3.13549421592915, 
    3.13549421592915, 3.13549421592915, 3.13549421592915, 3.58351893845611, 
    3.58351893845611, 3.58351893845611, 3.58351893845611, 3.25809653802148, 
    3.25809653802148, 3.25809653802148, 3.25809653802148, 3.25809653802148, 
    3.25809653802148, 3.25809653802148, 3.25809653802148, 3.3322045101752, 
    3.3322045101752, 3.3322045101752, 3.3322045101752, 3.43398720448515, 
    3.43398720448515, 3.43398720448515, 3.43398720448515, 3.46573590279973, 
    3.46573590279973, 3.46573590279973, 3.46573590279973, 3.04452243772342, 
    3.04452243772342, 3.04452243772342, 3.04452243772342, 3.36729582998647, 
    3.36729582998647, 3.36729582998647, 3.36729582998647, 3.04452243772342, 
    3.04452243772342, 3.04452243772342, 3.04452243772342, 3.46573590279973, 
    3.46573590279973, 3.46573590279973, 3.46573590279973, 3.2188758248682, 
    3.2188758248682, 3.2188758248682, 3.2188758248682, 3.40119738166216, 
    3.40119738166216, 3.40119738166216, 3.40119738166216, 3.68887945411394, 
    3.68887945411394, 3.68887945411394, 3.68887945411394, 2.94443897916644, 
    2.94443897916644, 2.94443897916644, 2.94443897916644, 3.09104245335832, 
    3.09104245335832, 3.09104245335832, 3.09104245335832, 2.89037175789616, 
    2.89037175789616, 2.89037175789616, 2.89037175789616, 3.46573590279973, 
    3.46573590279973, 3.46573590279973, 3.46573590279973, 2.99573227355399, 
    2.99573227355399, 2.99573227355399, 2.99573227355399, 3.40119738166216, 
    3.40119738166216, 3.40119738166216, 3.40119738166216, 2.89037175789616, 
    2.89037175789616, 2.89037175789616, 2.89037175789616, 3.17805383034795, 
    3.17805383034795, 3.17805383034795, 3.17805383034795, 3.40119738166216, 
    3.40119738166216, 3.40119738166216, 3.40119738166216, 3.55534806148941, 
    3.55534806148941, 3.55534806148941, 3.55534806148941, 3.29583686600433, 
    3.29583686600433, 3.29583686600433, 3.29583686600433, 2.99573227355399, 
    2.99573227355399, 2.99573227355399, 2.99573227355399, 3.09104245335832, 
    3.09104245335832, 3.09104245335832, 3.09104245335832, 3.3322045101752, 
    3.3322045101752, 3.3322045101752, 3.3322045101752, 3.13549421592915, 
    3.13549421592915, 3.13549421592915, 3.13549421592915, 3.68887945411394, 
    3.68887945411394, 3.68887945411394, 3.68887945411394, 3.49650756146648, 
    3.49650756146648, 3.49650756146648, 3.49650756146648, 3.04452243772342, 
    3.04452243772342, 3.04452243772342, 3.04452243772342, 3.55534806148941, 
    3.55534806148941, 3.55534806148941, 3.55534806148941, 3.2188758248682, 
    3.2188758248682, 3.2188758248682, 3.2188758248682, 3.25809653802148, 
    3.25809653802148, 3.25809653802148, 3.25809653802148, 3.2188758248682, 
    3.2188758248682, 3.2188758248682, 3.2188758248682, 3.09104245335832, 
    3.09104245335832, 3.09104245335832, 3.09104245335832, 3.46573590279973, 
    3.46573590279973, 3.46573590279973, 3.46573590279973, 3.2188758248682, 
    3.2188758248682, 3.2188758248682, 3.2188758248682, 3.55534806148941, 
    3.55534806148941, 3.55534806148941, 3.55534806148941, 3.04452243772342, 
    3.04452243772342, 3.04452243772342, 3.04452243772342, 3.71357206670431, 
    3.71357206670431, 3.71357206670431, 3.71357206670431, 3.46573590279973, 
    3.46573590279973, 3.46573590279973, 3.46573590279973, 3.25809653802148, 
    3.25809653802148, 3.25809653802148, 3.25809653802148, 3.04452243772342, 
    3.04452243772342, 3.04452243772342, 3.04452243772342, 3.58351893845611, 
    3.58351893845611, 3.58351893845611, 3.58351893845611, 3.61091791264422, 
    3.61091791264422, 3.61091791264422, 3.61091791264422)), .Names = c("y", 
"trt", "base", "age", "V4", "subject", "period", "lbase", "lage", 
"Visit", "Base", "Age"), row.names = c("1", "2", "3", "4", "5", 
"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", 
"17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", 
"28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", 
"39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", 
"50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", 
"61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", 
"72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", 
"83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", 
"94", "95", "96", "97", "98", "99", "100", "101", "102", "103", 
"104", "105", "106", "107", "108", "109", "110", "111", "112", 
"113", "114", "115", "116", "117", "118", "119", "120", "121", 
"122", "123", "124", "125", "126", "127", "128", "129", "130", 
"131", "132", "133", "134", "135", "136", "137", "138", "139", 
"140", "141", "142", "143", "144", "145", "146", "147", "148", 
"149", "150", "151", "152", "153", "154", "155", "156", "157", 
"158", "159", "160", "161", "162", "163", "164", "165", "166", 
"167", "168", "169", "170", "171", "172", "173", "174", "175", 
"176", "177", "178", "179", "180", "181", "182", "183", "184", 
"185", "186", "187", "188", "189", "190", "191", "192", "193", 
"194", "195", "196", "197", "198", "199", "200", "201", "202", 
"203", "204", "205", "206", "207", "208", "209", "210", "211", 
"212", "213", "214", "215", "216", "217", "218", "219", "220", 
"221", "222", "223", "224", "225", "226", "227", "228", "229", 
"230", "231", "232", "233", "234", "235", "236"), class = "data.frame")
 
