library(stockassessment)
 
setwd("data")  
cn<-read.ices("cn.dat")
cw<-read.ices("cw.dat")
dw<-read.ices("dw.dat")
lf<-read.ices("lf.dat")
lw<-read.ices("lw.dat")
mo<-read.ices("mo.dat")
nm<-read.ices("nm.dat")
pf<-read.ices("pf.dat")
pm<-read.ices("pm.dat")
sw<-read.ices("sw.dat")
surveys<-read.ices("survey.dat")

cn[cn==1]<-NA  ## !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! REMOVING 1's

dat<-setup.sam.data(surveys=surveys,
                    residual.fleet=cn, 
                    prop.mature=mo, 
                    stock.mean.weight=sw, 
                    catch.mean.weight=cw, 
                    dis.mean.weight=dw, 
                    land.mean.weight=lw,
                    prop.f=pf, 
                    prop.m=pm, 
                    natural.mortality=nm, 
                    land.frac=lf)
                    

nmOldAdj <- read.ices("nmOldAdj.dat")
pccfiles <- unzip("pcc.zip")
pcc <- lapply(pccfiles,function(f)read.table(f, sep=",", head=FALSE, skip=1))
names(pcc) <- regmatches(pccfiles,regexpr("[[:digit:]]+",pccfiles)) # extract year from filename
unlink(pccfiles)
                    

save(dat, nmOldAdj, pcc, file="../run/data.RData")
