library(stockassessment)
source("src/common.R")
# load what has been saved
setwd("run")
for(f in dir(pattern="RData"))load(f) 
setwd("..")

# read-in admb ssas for saithe 
#admb.res <- read.table("data/admb.dat",header=T)

# read-in observed catches for saithe, added:NWWG2019
#catch_obs <- read.table("data/LN.dat",skip=5)


#catchfunction <- function(fit)
#{
#	idx <- names(fit$sdrep$value) == "logCatch"
#	y <- fit$sdrep$value[idx]
#	ci <- y + fit$sdrep$sd[idx] %o% c(-2, 2)
#	ret <- cbind(y, ci)
#	colnames(ret) <- c("catch", "Low", "Hig")
#	rownames(ret) <- 1961:2021
#	return(ret)
#}
#catch_fit <- exp(catchfunction(fit))#/1000

#catch_fit_obs <- round(cbind(catch_fit,catch_obs=catch_obs[1:60,]),0)



basefit<-NULL
if(file.exists("baserun/model.RData")){
  local({load("baserun/model.RData"); basefit<<-fit})
  if(abs(logLik(basefit)-logLik(fit))<1.0e-9)basefit<<-fit
}


plotcounter<-1
tit.list<-list()

setcap<-function(title="", caption=""){   
 tit.list[length(tit.list)+1]<<-paste("# Title",plotcounter,"\n")
 tit.list[length(tit.list)+1]<<-paste(title,"\n")
 tit.list[length(tit.list)+1]<<-paste("# Caption",plotcounter,"\n")
 tit.list[length(tit.list)+1]<<-paste(caption,"\n")
 plotcounter<<-plotcounter+1 
}


############################## plots ##############################
plots<-function(){
  par(cex.lab=1, cex.axis=1, mar=c(5,5,1,1))
    
  if(exists("fit")){
    fits <- c(fit,basefit)
    
    ssbplot(fits, addCI=TRUE)
    #lines(admb.res$year,admb.res$SSB*1000,col=2,lwd=2)
    stampit()
    setcap("Spawning stock biomass", "Spawning stock biomass. 
            Estimates from the current run and point wise 95% confidence 
            intervals are shown by black line and shaded area.")
    
    fbarplot(fits, addCI=TRUE)
    #lines(admb.res$year,admb.res$Fbar,col=2,lwd=2)
    stampit()
    setcap("Fishing mortality (ages 4-8)", "Fishing mortality (ages 4-8). 
            Estimates from the current run and point wise 95% confidence 
            intervals are shown by black line and shaded area.")


    recplot(fits, addCI=TRUE, las=0)
    #lines(admb.res$year,admb.res$Rec*1000,col=2,lwd=2)
    stampit()
    setcap("Recruitment (age 3)", "Recruitment (age 3). 
            Estimates from the current run and point wise 95% confidence 
            intervals are shown by black line and shaded area.")

    catchplot(fits, addCI=TRUE)
    #lines(admb.res$year,admb.res$Lan_hat*1000,col=2,lwd=2)
    stampit()
    setcap("Total landings=catch", "Total catch (tons). 
            Estimates from the current run and point wise 95% confidence 
            intervals are shown by black line and shaded area. Observed catch shown as \"x\"")

    srplot(fit)
    stampit()
    setcap("Spawner-recruits", "Estimated recruitment as a function of spawning stock biomass.")

    
    #plot(ypr(fits, aveYears = 20))
    #stampit()
    #setcap("Yield-per-recruit", "Yield-per-recruit analysis.")

    
    obscorrplot(fit)
    stampit()
        
    for(f in 1:fit$data$noFleets){
      fitplot(fit, fleets=f)
      stampit()
    }
    setcap("Correlation structure of observations", "Correlation structure of catch (top),
    summer index (middle) and spring index (bottom)")
    
    		## added today
		par<-coef(fit)
		par<-par[names(par)=="logSdLogObs"]
		mat<-cbind(as.vector(row(fit$conf$keyVarObs)), as.vector(col(fit$conf$keyVarObs)), c(NA,1/exp(2*par))[as.vector(fit$conf$keyVarObs)+2])
		mat[,3]<-mat[,3]/sum(mat[,3], na.rm=TRUE)
		o<-order(mat[,1],mat[,2])
		mat<-mat[o,]
		nam<-paste0("f=",mat[,1], ":a=",mat[,2])
		barplot(mat[,3], names.arg=nam, ylab="W (standardized reciprocal variance)", xlab="Fleet and age", col=mat[,1])
		stampit()


    #Q<-fit$pl$logFpar
    #Qsd<-fit$plsd$logFpar
    #key<-fit$conf$keyLogFpar
    #fun<-function(x)if(x<0){NA}else{Q[x+1]}
    #FF<-Vectorize(fun)
    #ages<-fit$conf$minAge:fit$conf$maxAge
    #matplot(ages, exp(t(matrix(FF(key), nrow=5))), type="l", lwd=5, lty="solid", xlab="Ages", ylab="Q")
    #legend("topright", lwd=5, col=2:5, legend=attr(fit$data, "fleetNames")[2:5])
    #stampit()

  }  
  
  if(exists("RES")){  
    plot(RES)
    par(mfrow=c(1,1))
    stampit()
  
  }
  setcap("Fit to catch data","Fit to age-disagregated catches (ages 3-15)")

  
   
  if(exists("RESP")){  
    plot(RESP)
    par(mfrow=c(1,1))
    stampit()
  } 
  setcap("Fit to summer survey data","Fit to age-disagregated summer index (ages 3-10)")
  setcap("Fit to spring survey data","Fit to age-disagregated spring index (ages 3-10)")
  setcap("Model observation residuals","Catch residuals (top), summer survey (residuals), spring survey residuals (bottom)")
  setcap("Model process-error","Errors in N-process (top) and in F-process (bottom)")
  
  if(exists("LO")){  
    ssbplot(LO)
    stampit()
    setcap("Spawning stock biomass (leave-one-out analysis)","SSB estimates without spring (light blue) and summer index (blue) respectively.
    Estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")
    
    fbarplot(LO)
    stampit()
    setcap("Fishing mortality (ages 4-8, Fbar) (leave-one-out analysis)","Fbar estimates without spring (light blue) and summer index (blue) respectively.
    Estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")

    recplot(LO)
    stampit()
    setcap("Recruitment at age 3 (leave-one-out analysis)","Recruitment estimates without spring (light blue) and summer index (blue) respectively.
    Estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")

    catchplot(LO)
    stampit()
    setcap("Annual landings (leave-one-out analysis)","Landings estimates without spring (light blue) and summer index (blue) respectively.
    Estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")
    
  } 
  
if(exists("RETRO")){  
    rho <- mohn(RETRO)
    rho2 <- mohn(RETRO, lag = 1)
    ssbplot(RETRO, las=0, drop=0)
    legend("topright", legend=paste0("Rho ",round(rho[2]*100),"%"))
    stampit()
    setcap("Spawning stock biomass (retro analysis)","Spawning stock biomass. SSB estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")

    
    fbarplot(RETRO, las=0, drop=1)
    legend("topright", legend=paste0("Rho ",round(rho2[3]*100),"%"))  
    stampit()
    setcap("Fishing mortality (ages 4-8)(retro analysis)","Fishing mortality (Fbar). Fbar estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")
    
    recplot(RETRO, las=0, drop=0)
    legend("topright", legend=paste0("Rho ",round(rho[1]*100),"%"))
    stampit()
    setcap("Recruitment (age 3)(retro analysis)","Recruitment (age 3). Recruitment estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")

    catchplot(RETRO)
    stampit()
    setcap("Annual landings (retro analysis)","Annual landings. Landing estimates from the current run and point wise 95% confidence intervals are shown by black line and shaded area.")
    
  }
  if(exists("FC")){  
    lapply(FC, function(f){plot(f); title(attr(f,"label"), outer=TRUE, line=-1); stampit()})
  }
  setcap("Forecast","Forecast with status quo F")
  setcap("Forecast","Fmsy=0.30 forecast")
  setcap("Forecast","Forecast with status quo F in the intermediate year followed by Fpa=0.52")
  setcap("Forecast","Forecast with status quo F in the intermediate year followed by Flim=0.70")
  setcap("Forecast","Forecast with status quo F in the intermediate year followed by F=0")
    
}


setwd('res')
file.remove(dir(pattern='png$'))
stamp<-gsub('-[[:digit:]]{4}$','',gsub(':','.',gsub(' ','-',gsub('^[[:alpha:]]{3} ','',date()))))
png(filename = paste(stamp,"_%03d.png", sep=''), width = 480, height = 480,
    units = "px", pointsize = 10, bg = "white")
  plots()    
dev.off()

writeLines(unlist(tit.list),'titles.cfg') 

png(filename = paste("big_",stamp,"_%03d.png", sep=''), width = 1200, height = 1200, 
    units = "px", pointsize = 20, bg = "white")
  plots()    
dev.off()

#pdf(onefile=FALSE, width = 8, height = 8)
#  plots()    
#dev.off()

file.remove(dir(pattern='html$'))

# added NWWG2019
#xtab(catch_fit_obs, caption=paste('Table 1a. Estimated and observed catch','.',sep=''), cornername='Year', 
#     file=paste(stamp,'_tab1a.html',sep=''), dec=c(0,0,0,0))


tsb<-tsbtable(fit)
colnames(tsb)<-c("TSB","Low", "High")
tab.summary <- cbind(summary(fit), tsb)
xtab(tab.summary, caption=paste('Table 1. Estimated recruitment, spawning stock biomass (SSB), 
     and average fishing mortality','.',sep=''), cornername='Year', 
     file=paste(stamp,'_tab1.html',sep=''), dec=c(0,0,0,0,0,0,3,3,3,0,0,0))

ftab <- faytable(fit)
xtab(ftab, caption=paste('Table 2. Estimated fishing mortality at age','.',sep=''), cornername='Year \ Age', 
     file=paste(stamp,'_tab2.html',sep=''), dec=rep(3,ncol(ftab)))

ntab <- ntable(fit)
xtab(ntab, caption=paste('Table 3. Estimated stock numbers at age','.',sep=''), cornername='Year \ Age', 
     file=paste(stamp,'_tab3.html',sep=''), dec=rep(0,ncol(ntab)))

ptab <- partable(fit)
xtab(ptab, caption=paste('Table 4. Table of model parameters','.',sep=''), cornername='Parameter name', 
     file=paste(stamp,'_tab4.html',sep=''), dec=rep(3,ncol(ptab)))


mtab <- modeltable(c(Current=fit, base=basefit))
mdec <- c(2,0,2,6)[1:ncol(mtab)]
xtab(mtab, caption=paste('Table 5. Model fitting','.',sep=''), cornername='Model', 
     file=paste(stamp,'_tab5.html',sep=''), dec=mdec)

sdState<-function(fit, y=max(fit$data$years)-1:0){
  idx <- names(fit$sdrep$value) == "logR"
  sdLogR<-fit$sdrep$sd[idx][fit$data$years%in%y]
  idx <- names(fit$sdrep$value) == "logssb"
  sdLogSSB<-fit$sdrep$sd[idx][fit$data$years%in%y]
  idx <- names(fit$sdrep$value) == "logfbar"
  sdLogF<-fit$sdrep$sd[idx][fit$data$years%in%y]
  ret<-cbind(sdLogR, sdLogSSB, sdLogF)
  rownames(ret)<-y
  colnames(ret)<-c("sd(log(R))", "sd(log(SSB))", "sd(log(Fbar))")
  return(ret)
}

sdtab<-sdState(fit)
xtab(sdtab, caption=paste('Table 6. Table of selected sd','.',sep=''), cornername='Year', 
     file=paste(stamp,'_tab6.html',sep=''), dec=rep(3,ncol(sdtab)))



if(exists("FC")){  
    ii<-0
    lapply(FC, function(f){
       ii<<-ii+1;
       tf<-attr(f,"tab");
       dec<-c(3,3,3,rep(0,ncol(tf)-3));
       xtab(tf, caption=paste0('Forecast table ',ii,'. ', attr(f,"label"),'.'), 
       cornername='Year', file=paste(stamp,'_tabX',ii,'.html',sep=''), dec=dec);      
       })
}  

setwd("..") 

