library(stockassessment)
load("run/model.RData")
FC<-list()
Ry<-2019:2023
set.seed(12345)
#cw2 <- read.ices("data/cw2.dat")
fit2<-fit

#cw <- fit2$data$catchMeanWeight
#nr<-nrow(fit2$data$catchMeanWeight)
#fit2$data$catchMeanWeight[nr+c(-4:0),]<-cw2[rep(nrow(cw2),5),]


# Forecast Fmsy advice - Adopted by adg in 2020
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,0.30,0.30,0.30), rec.years=Ry,processNoiseF = FALSE,  label="Fmsy=0.30 - ADG 2020", addTSB=TRUE)

# Forecast Fmsy advice - IBPFAR 2022
Fmsy_val=0.38
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,Fmsy_val,Fmsy_val,Fmsy_val), rec.years=Ry,processNoiseF = FALSE,  label="Fmsy=0.38 - IBPFAR 2022", addTSB=TRUE)

# Forecast F SQ in 2023-2024 then Fmsy=0.38
Fmsy_val=0.38
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,1,NA,NA), fval=c(NA,NA,Fmsy_val,Fmsy_val), rec.years=Ry,processNoiseF = FALSE,  label="Forecast F SQ in 2024-2025 then Fmsy=0.38", addTSB=TRUE)


# Forecast SQ
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,1,1,1), rec.years=Ry,processNoiseF = FALSE,  label="F SQ - IBPFAR 2022", addTSB=TRUE)

# Forecast F=0
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,0.000001,0.000001,0.000001), rec.years=Ry,processNoiseF = FALSE,  label="Flim=0 - IBPFAR 2022", addTSB=TRUE)

# Forecast Fpa
Fpa_val=0.62
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,Fpa_val,Fpa_val,Fpa_val), rec.years=Ry,processNoiseF = FALSE,  label="Fpa=0.62 - IBPFAR 2022", addTSB=TRUE)

# Forecast Flim
Flim_val=0.98
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,Flim_val,Flim_val,Flim_val), rec.years=Ry,processNoiseF = FALSE,  label="Flim=0.98 - IBPFAR 2022", addTSB=TRUE)

##                                                                        ##
## Fmsy advice in case SSB(assessment year +1) is below Btrigger = 36412  ##
##                                                                        ##

# Fmsyadvice <- Fmsy * SSB(2022) / Btrigger -- Assessment 2021 -> SSB(2022) .. Assessment 2022 -> SSB(2023)
# Fmsyadvice <- 0.38 * SSB(2022) / 36412    -- Assessment 2021 -> SSB(2022) .. Assessment 2022 -> SSB(2023)

#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA, Fmsyadvice, Fmsyadvice, Fmsyadvice), rec.years=Ry, processNoiseF = FALSE, label="SQ then Fmsy Advice", addTSB=TRUE)





# Forecast Fmsy advice - IBPFAR 2022 processNoiseF = FALSE,
#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit2, fscale=c(1,NA,NA,NA), fval=c(NA,0.38,0.38,0.38), rec.years=Ry, processNoiseF = FALSE, overwriteSelYears=2018:2020, label="Fmsy=0.38 - IBPFAR 2022", #addTSB=TRUE,year.base=2021)

save(FC, file="run/forecast.RData")
