library(stockassessment)
setwd("run")
load("data.RData")
conf<-loadConf(dat,"../conf/model.cfg", patch=TRUE)
par<-defpar(dat,conf)
par$logSdLogN[2]<-log(0.05)#new in 2025
set.seed(1337) #new in 2025 - resets start value
fit<-sam.fit(dat,conf,par,map=list(logSdLogN=as.factor(c(1,NA))))
if(fit$opt$convergence!=0) stop("Model did not converge.")
save(fit, file="model.RData")
