# Stockassessment.org
# Adapted from cod6a_WGCSE2020_final
# And Celtic Sea cod 


# clear all memory
# rm(list = ls())


library(stockassessment)
# load("C:/Users/jwhite/Desktop/Assmsnt_Org_had/model.RData")
load("run/model.RData")

N.SIM <- 10001  # set the number of iterations the the stochastic forecasts   
# Note - the number of iterations 10001, up from 1001. All are stable if seed is set - standard "12345" used.
# set to 101 for quick checking
# set to 1001 for routine checking
# set to 10001 preference

###############################
## Reference points  
# 24-Aug-2020  Ref points updated following inclusion of 2019 data into model.
F_MSY <- 0.353        # 0.312 		# Median point estimates of (F05) EqSim with combined SR
F_MSY_lower <- 0.221  # 0.206	    # Median lower point estimates of (F05) EqSim with combined SR
F_MSY_upper <- 0.521  # 0.456 	  	# Median upper point estimates of (F05) EqSim with combined SR
Fpa <- 0.708          # 0.92        # F05.   # was Fpa  1.01 in first 2020  Flim combined with the assessment error
Flim <- 1.40          # 1.28      	# F with 50% probability of SSB less than Blim
Blim <- 9227          # 9420      	# Lowest SBB with above-average recruitment
Bpa <- 12822          # 13089     	# Blim combined with the assessment error
MSY_Btrigger <- 12822 # 13089 		# Bpa


# For forecast SSB target 
# Stepwise % increases
# Set Fmsy SSB forecast in 2019 for 2021

# median(FC[[1]][[3]]$ssb) - this is the Fmsy SSB 2021 forecast
# median(FC[[8]][[3]]$ssb) - this is the SQ SSB 2021 forecast


###############################
## TAC & advice for 2024 

prev.advice <- 8252  # note, this is not used in the forecast belwo. Here fore reference.   16671  2020 # Input catch advice from proceeding year   ## 2018 advice <- 8358   ## 2017 advice  <- 12444
prev.TAC <- 11901   # note, this is not used in the forecast belwo. Here fore reference.  2021, "prev.TAC" taken as full ICES single stock advice owing to lack of full year TAC due to Brexit negotiations.  14678 was propsed as 100% EY and 100% UK.  # 10859  2020 # Input TAC in intermediate year - in assessment year 2018 from COUNCIL REGULATION (EU) 2018/120 - COUNCIL REGULATION 2020_123 TAC.pdf   HAD/7X7A34

## 2022 catch
cur.cat <- 9964  # 11259  # From 2019 catch work up "HAD 7b-k International CNAA 93-19-WORKING_July_2020.xlsx" 
#12204 wgcse2021


###############################
## Forecast Assumptions

first.yr <-1993 # min(fit$data$years)  # First year in the assessment (intermediate year) for help estimating intermediate year Recruitment 
final.yr <-max(fit$data$years)  # Final year in the assessment (intermediate year) for help estimating intermediate year Recruitment 
R.range.yrs <-seq(first.yr,final.yr,1)  # Resample R from previous years, start of the time series to end of time series (median is calculated)
av.yrs <- final.yr+(-2:0)  # final.yr   # Use last three years for mean weights & L-D partition  ##  final.yr+(-2:0) # this is last three years, so five years would be: Ay <- lastyear +(-4:0)
# sel.yrs <-2017:2019  # Use 3 year average selection pattern
# f_mean <-fbartable(fit)[as.character(final.yr-1),"Estimate"] # status quo is rescaled to 2019  
# f_mean <-fbartable(fit)[as.character(2019),"Estimate"] # status quo is rescaled to 2019

#  Fsq <- tail(fbartable(fit),1)[1]  	 # Get Fsq from the summary table    # [1] 0.4058268  checked - 18/Sept/2020
#  This is equivelent of FLR code "fLastYr3to5 <- mean(harvest(stf0[4:6,nyears-0]) )" #  [1] 0.4058268 
F_last <- tail(fbartable(fit),1)[,"Estimate"]  
# Fsq <- tail(fbartable(fit),1)[1]   # another way to calculate it: f_mean <-fbartable(fit)[as.character(2019),"Estimate"] 
# Fsq <- mean(tail(fbartable(fit),3)[,"Estimate"])
# or for scaled F:  (# F status quo is rescaled to the last year - this is 2019 in the case of the 2020 assessment)  
F_sq <- F_last

# Note - F_sq and F_last are (is) the F used for the faorecast, 
# This F is "rescaled" over the average proprtional age structure seen in the number of years defined by "av.yrs" above

SSBNext <- 13307 #27904  # An initial run of the forecast is necessary to get this value. It's median SSB in the next year, so in assessment year 2022, it iss SSB in 2023)
#62437 was wgcse2021 value
#47157 was wgcse2022 value


###############################
## forecast names and structure part 1
## Forecasts

scen <- list(
  "MSY approach: F_MSY" = list(fval = c(F_last, F_sq, F_MSY, F_MSY)),
  "Precautionary approach: Fpa" = list(fval = c(F_last,F_sq, Fpa, Fpa)),
  "FMSY upper" = list(fval = c(F_last, F_sq, F_MSY_upper, F_MSY_upper)),
  "FMSY lower" = list(fval = c(F_last, F_sq, F_MSY_lower, F_MSY_lower)),
  "F = 0" = list(fval = c(F_last, F_sq, 0.000001 ,0.000001)),
  "Fpa" = list(fval = c(F_last,F_sq, Fpa, Fpa)),
  "F = Flim" = list(fval = c(F_last, F_sq, Flim, Flim)),
  "Fsq"  = list(fval = c(F_last, F_sq, F_sq, F_sq)),
  "hit Blim" = list(fval = c(F_last, F_sq, NA,NA), nextssb = c(NA, NA, Blim, Blim)),
  "hit Bpa" = list(fval = c(F_last, F_sq, NA,NA), nextssb = c(NA, NA, Bpa, Bpa)) ,
  "hit MSY Btrigger" = list(fval = c(F_last, F_sq, NA, NA), nextssb = c(NA, NA, MSY_Btrigger, MSY_Btrigger)),
  "SSB Y+2 = SSB Y+1"  = list(fval = c(F_last, F_sq, NA, NA), nextssb = c(NA, NA, SSBNext, SSBNext))
)

FC <- ""
FC <- vector("list", length(scen))
names(FC) <- names(scen)


for(i in seq(scen)){
  set.seed(12345)
  ARGS <- scen[[i]]
  ARGS <- c(ARGS,
            list(fit = fit, ave.years=av.yrs, rec.years=R.range.yrs, label=names(scen)[i], splitLD=TRUE, nosim = N.SIM))  
  FC[[i]] <- do.call(forecast, ARGS)
  
  print(paste0("forecast : ", "'", names(scen)[i], "'", " is complete"))
}




    ## Check for FC file structure  09/06/2021
    # FCMSY <-list()
    # set.seed(12345)
    # FCMSY <- forecast(fit, label = "MSY approach: Fmsy", fval = c(F_last, F_sq, F_MSY, F_MSY), ave.years=av.yrs, rec.years=R.range.yrs,  splitLD=TRUE, nosim = N.SIM)
    # save(FCMSY, file="run/forecastFCMSY.RData")




###############################
## forecast names and structure part 2
## ICES advice rule for MSY

MSYappr <- function(fit, Fmsy=NULL, Btrig=NULL, fscale_init=1, fval_init=NA, catchval_init=NA, label=NA)
{
  fscale <- fscale_init
  fval <- fval_init
  catchval <- catchval_init
  
  for (i in 2:4){
    fscale[i] <- NA
    fval[i] <- Fmsy
    catchval[i] <- NA
    
    set.seed(12345)
    # f1 <- forecast(fit, fscale=fscale, fval=fval, catchval=catchval, ave.years=av.yrs, rec.years=R.range.yrs, splitLD=TRUE, nosim=N.SIM)
    f1 <- forecast(fit, fscale=fscale, fval=fval, catchval=catchval, ave.years=av.yrs, rec.years=R.range.yrs, splitLD=TRUE, nosim=N.SIM, savesim=TRUE)
    SSB <- attr(f1,"shorttab")[3,i]
    ## fval[i] <- min(Fmsy*SSB/Btrig, Fmsy) ## linear scaling between B=0 and B=Btrigger
    ## linear scaling between F=0 for B=Blim and F=Fmsy for B=Btrigger	
    a <-  (F_MSY / (Btrig-Blim))
    b <- -a*Blim
    if(SSB < Btrig && SSB > Blim) fval[i] <- a*SSB + b
    if(SSB < Blim) fval[i] <- 0.000001
  }
  
  set.seed(12345)
  f_final <- forecast(fit, fscale=fscale, fval=fval, catchval=catchval, ave.years=av.yrs, rec.years=R.range.yrs, splitLD=TRUE, label=label, nosim=N.SIM)
  return(f_final)
  
}


#FC


# save(FC, file="run/forecast.RData", savesim=TRUE)
save(FC, file="run/forecast.RData")
# save(FC, file="C:/Users/jwhite/Desktop/Assmsnt_Org_had/Had.27.7b-k_Forecast_Working_July_2020.RData")




## to check interium rectuitment estimate  
# library(stockassessment)
# fit=fitfromweb("HAD7bk_2020_Assessment")
# rec = ntable(fit)[,1]
# median(rec)
# sort(rec)[25]
# sort(rec)[26]
# sort(rec)[27]
# 
# length(rec)