library(stockassessment)

oldwd<-setwd("data")

  cn<-read.ices("cn.dat")
  cw<-read.ices("cw.dat")
  dw<-read.ices("dw.dat")
  lw<-read.ices("lw.dat")
  mo<-read.ices("mo.dat")
  nm<-read.ices("nm.dat")
  pf<-read.ices("pf.dat")
  pm<-read.ices("pm.dat")
  sw<-read.ices("sw.dat")
  lf<-read.ices("lf.dat")
  suppressWarnings( surveys<-read.ices("survey.dat"))

setwd(oldwd)

## downweight early catch-at-age 
## basically you add an attribute called "weight" which should be 
## a matrix with same dimensions as the observations which contains
## the relative precision ( 1 / variance ))

cvw <- matrix(1,nrow=nrow(cn),ncol=ncol(cn))
for(y in 1:9) for(a in y:ncol(cn)) cvw[y,a] <- 0.25
attributes(cn)$weight <- cvw


dat<-setup.sam.data(surveys=surveys,
                    residual.fleet=cn, 
                    prop.mature=mo, 
                    stock.mean.weight=sw, 
                    catch.mean.weight=cw, 
                    dis.mean.weight=dw, 
                    land.mean.weight=lw,
                    prop.f=pf, 
                    prop.m=pm, 
                    natural.mortality=nm, 
                    land.frac=lf)


dat <- reduce(dat,fleet=4)

dat <- reduce(dat,fleet=3)

dat <- reduce(dat,fleet=2,age=c(8))


save(dat, file="run/data.RData")
