library(stockassessment)
load("run/model.RData")
Fbar<-tail(fbartable(fit),1)[1]
TAC<-8264

# hack to use the biopar estimates also in the last assessment year 
nr<-nrow(fit$data$stockMeanWeight)
fit$data$stockMeanWeight[nr,]<-exp(fit$pl$logSW)[nr,]
nr<-nrow(fit$data$catchMeanWeight[,,1])
fit$data$catchMeanWeight[nr,,1]<-exp(fit$pl$logCW)[nr,,1]

FC<-list()

# SQ all years
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar, Fbar, Fbar, Fbar), processNoiseF=FALSE, label="SQ F all years")

#Zero all years
# SQ then zero
#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,0.000001,0.000001, 0.000001), processNoiseF=FALSE, label="zero all years")


# SQ then zero
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,0.000001, 0.000001), processNoiseF=FALSE, label="SQ F then zero")

# 2025= TAC the SQ all years
#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit, catchval=c(NA,TAC,NA, NA), fval=c(Fbar, NA, 1.21, 1.21), processNoiseF=FALSE, label="2025F=TAC then SQ F")


# SQ then zero
#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit, catchval=c(NA,TAC,NA, NA), fval=c(Fbar,NA,0.000001, 0.000001), processNoiseF=FALSE, label="2025F=TACF then zero")




#Fmsy
set.seed(12345)
Fmsy<-0.27
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,Fmsy, Fmsy), processNoiseF=FALSE, label="2025F=2024F then Fmsy")

#Fmsy - 2024 SSB below Btrigger - so use Fmsy*(SSB2025/Btrigger)
#set.seed(12345)
#FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,xx, xx), processNoiseF=FALSE, label="2024F=2023F then Fmsy (reduced based on Btrigger")

# 2025 catch based on TAC
#set.seed(12345)
#Fmsy<-0.27
#TAC<-8264
#FC[[length(FC)+1]] <- forecast(fit, catchval=c(NA,TAC,NA, NA),fval=c(Fbar,NA,Fmsy, Fmsy), processNoiseF=FALSE, label="2025F=TAC then Fmsy")





save(FC, file="run/forecast.RData")