library(stockassessment)
load("run/model.RData")
Fbar<-tail(fbartable(fit),1)[1]

FC<-list()

# SQ all years
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar, Fbar, Fbar, Fbar), processNoiseF=FALSE, label="SQ all years")

# SQ then zero
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,0.000001,0.000001, 0.000001), processNoiseF=FALSE, label="SQ then zero")

#F=0
set.seed(12345)
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,0.000001, 0.000001), processNoiseF=FALSE, label="2024F=2023F then zero")

#Fmsy
set.seed(12345)
Fmsy<-0.54
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,Fmsy, Fmsy), processNoiseF=FALSE, label="2024F=2023F then Fmsy")

#Fmsyower
set.seed(12345)
Fmsylow<-0.27
FC[[length(FC)+1]] <- forecast(fit, fval=c(Fbar,Fbar,Fmsylow, Fmsylow), processNoiseF=FALSE, label="2024F=2023F then Fmsylower")


save(FC, file="run/forecast.RData")
